package com.elitescloud.cloudt.system.service.model.entity;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.DynamicInsert;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.util.Objects;

/**
 * 员工组的员工.
 *
 * @author Kaiser（wang shao）
 * @date 2023/2/2
 */
@Entity
@Table(name = "sys_emp_group_emp", indexes = {
        @Index(name = "idx_emp_group_emp_g", columnList = "groupId"),
        @Index(name = "idx_emp_group_emp_e", columnList = "empId"),
})
@Comment("员工组的员工")
@DynamicInsert
@Getter
@Setter
public class SysEmpGroupEmpDO extends BaseModel {
    private static final long serialVersionUID = 3853735748353968422L;

    @Comment(value = "员工组ID")
    @Column(nullable = false)
    private Long groupId;

    @Comment(value = "员工ID")
    @Column(nullable = false)
    private Long empId;

    @Override
    public int hashCode() {
        return Objects.hashCode(getId());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof SysEmpGroupEmpDO) {
            SysEmpGroupEmpDO the = (SysEmpGroupEmpDO) obj;
            if (getId() == null) {
                return the.getId() == null;
            }
            return getId().equals(the.getId());
        }
        return false;
    }
}
