package com.elitescloud.cloudt.system.service.model.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.system.service.common.constant.OpenApiSourceEnum;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.DynamicInsert;

import javax.persistence.*;

/**
 * OpenAPI操作信息.
 *
 * @author Kaiser（wang shao）
 * @date 2024/3/4
 */
@Entity
@Table(name = "sys_openapi_operation", indexes = {
        @Index(name = "idx_openapi_ope_info", columnList = "openApiInfoId"),
        @Index(name = "idx_openapi_ope_code", columnList = "operationCode", unique = true),
        @Index(name = "idx_openapi_ope_business", columnList = "businessOperation"),
        @Index(name = "idx_openapi_ope_summary", columnList = "summary"),
        @Index(name = "idx_openapi_ope_url", columnList = "url"),
})
@Comment("OpenAPI操作信息")
@DynamicInsert
@Getter
@Setter
public class SysOpenApiOperationDO extends BaseModel {
    private static final long serialVersionUID = 8215613442314466401L;

    @Comment(value = "openApi信息ID")
    @Column(nullable = false)
    private Long openApiInfoId;

    @Comment(value = "操作编码")
    @Column(nullable = false)
    private String operationCode;

    @Comment(value = "操作ID")
    @Column()
    @Lob
    private String operationId;

    @Comment(value = "摘要信息")
    @Column()
    private String summary;

    @Comment(value = "描述")
    @Column()
    private String description;

    @Comment(value = "标签列表json")
    @Column()
    @Lob
    private String tagsJson;

    @Comment(value = "原始数据的资源ID")
    @Column()
    private Long resourceId;

    @Comment(value = "是否含有业务操作", defaultValue = "0")
    @Column()
    private Boolean businessOperation;

    @Comment(value = "是否启用", defaultValue = "1")
    @Column()
    private Boolean enabled;

    @Comment(value = "接口地址")
    @Column()
    private String url;

    @Comment(value = "接口方法")
    @Column()
    private String method;

    /**
     * 数据来源
     * <p>
     * 取值：{@link OpenApiSourceEnum}
     */
    @Comment(value = "数据来源")
    @Column()
    private String dataSource;

    @Comment(value = "apiType类型 null|1=内部  2=外部（openfeign）")
    @Column()
    private Integer apiType;

    @Comment(value = "操作分组")
    @Column()
    private String operationGroup;
    @Column(length = 2000)
    private String    returnTypeJson;
    @Column(length = 2000)
    private String    parameterTypesJson;
}
