package com.elitescloud.cloudt.system.service.model.entity;

import com.elitescloud.boot.core.support.customfield.common.JsonStringMapConverter;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.DynamicInsert;

import javax.persistence.*;
import java.time.LocalDateTime;
import java.util.Map;

/**
 * 同步信息.
 *
 * @author Kaiser（wang shao）
 * @date 2024/8/21
 */
@Entity
@Table(name = "sys_sync", indexes = {
        @Index(name = "idx_sync_datatype", columnList = "dataType"),
        @Index(name = "idx_sync_datakey", columnList = "dataKey"),
        @Index(name = "idx_sync_outerdatakey", columnList = "outerDataKey"),
        @Index(name = "idx_sync_synctime", columnList = "syncDataTime"),
})
@Comment("同步信息")
@DynamicInsert
@Getter
@Setter
public class SysSyncDO extends BaseModel {
    private static final long serialVersionUID = -4532258824442939663L;

    /**
     * {@link com.elitescloud.cloudt.system.service.common.constant.SyncDataType}
     */
    @Comment(value = "数据类型")
    @Column(nullable = false)
    private String dataType;

    @Comment(value = "数据的唯一标识")
    @Column()
    private String dataKey;

    @Comment(value = "是否是向外同步")
    @Column()
    private Boolean syncOuter;

    @Comment(value = "外部系统标识")
    @Column(nullable = false)
    private String outerApp;

    @Comment(value = "外部数据的唯一标识")
    @Column()
    private String outerDataKey;

    @Comment(value = "同步时间")
    @Column()
    private LocalDateTime syncDataTime;

    @Comment(value = "是否手工同步")
    @Column()
    private Boolean manual;

    @Comment(value = "是否同步成功", defaultValue = "0")
    @Column()
    private Boolean syncSuccess;

    @Comment(value = "同步失败原因")
    @Column()
    @Lob
    private String failReason;

    @Comment(value = "扩展信息")
    @Column()
    @Lob
    @Convert(converter = JsonStringMapConverter.class)
    private Map<String, Object> attr;
}
