package com.elitescloud.cloudt.system.service.model.entity;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.time.LocalDateTime;
import java.util.Objects;

/**
 * 租户开通的业务应用.
 *
 * @author Kaiser（wang shao）
 * 2022/9/20
 */
@Entity
@Table(name = "sys_tenant_app", indexes = {
        @Index(name = "idx_tenant_app_tenant_id", columnList = "sysTenantId"),
        @Index(name = "idx_tenant_app_app_code", columnList = "appCode"),
})
@Comment("租户的应用")
@Getter
@Setter
public class SysTenantAppDO extends BaseModel {
    private static final long serialVersionUID = -6598008724925852455L;

    @Column(nullable = false)
    @Comment("租户ID")
    private Long sysTenantId;

    @Column(nullable = false)
    @Comment("应用编码")
    private String appCode;

    @Column(nullable = false)
    @Comment("分配时间")
    private LocalDateTime assignTime;

    @Override
    public int hashCode() {
        return Objects.hashCode(getId());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof SysTenantAppDO) {
            SysTenantAppDO the = (SysTenantAppDO) obj;
            if (getId() == null) {
                return the.getId() == null;
            }
            return getId().equals(the.getId());
        }
        return false;
    }
}
