package com.elitescloud.cloudt.system.service.model.entity;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.util.Objects;

/**
 * 租户组织.
 * <p>
 * 对多组织的支持，各组织之间通过逻辑字段隔离
 *
 * @author Kaiser（wang shao）
 * 2022/9/15
 */
@Entity
@Table(name = "sys_tenant_org", indexes = {
        @Index(name = "idx_tenant_org_org_id", columnList = "orgId"),
        @Index(name = "idx_tenant_org_admin_id", columnList = "adminId"),
})
@Comment("租户组织")
@Getter
@Setter
public class SysTenantOrgDO extends BaseModel {
    private static final long serialVersionUID = -8170613271268286752L;

    @Column(nullable = false)
    @Comment("组织ID")
    private Long orgId;

    @Column()
    @Comment("管理员用户ID")
    private Long adminId;

    @Column()
    @Comment(value = "是否启用", defaultValue = "1")
    private Boolean enabled;

    @Override
    public int hashCode() {
        return Objects.hashCode(getId());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof SysTenantOrgDO) {
            SysTenantOrgDO the = (SysTenantOrgDO) obj;
            if (getId() == null) {
                return the.getId() == null;
            }
            return getId().equals(the.getId());
        }
        return false;
    }
}
