package com.elitescloud.cloudt.system.service.model.entity;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.util.Objects;

/**
 * @author Michael Li
 * @date
 */
@Entity
@Table(name = "sys_user_role", indexes = {
        @Index(name = "idx_sys_user_role_user_id", columnList = "userId"),
        @Index(name = "idx_sys_user_role_role_id", columnList = "roleId")
})
@Comment("用户角色关联表")
@Getter
@Setter
public class SysUserRoleDO extends BaseModel {
    private static final long serialVersionUID = -8777065721688751524L;

    @Comment("用户ID")
    @Column(nullable = false)
    private Long userId;

    @Comment("角色ID")
    @Column(nullable = false)
    private Long roleId;

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SysUserRoleDO)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SysUserRoleDO entity = (SysUserRoleDO) o;
        return getId().equals(entity.getId());
    }

    @Override
    public int hashCode() {
        return Objects.hash(getId());
    }
}