package com.elitescloud.cloudt.system.service.model.entity;

import com.elitescloud.boot.core.support.customfield.common.JsonStringMapConverter;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.*;
import java.time.LocalDateTime;
import java.util.Map;

/**
 * 账号同步记录.
 *
 * @author Kaiser（wang shao）
 * @date 2024/7/30
 */
@Entity
@Table(name = "sys_user_sync", indexes = {
        @Index(name = "idx_sys_user_sync_outersys", columnList = "outerSysCode"),
        @Index(name = "idx_sys_user_sync_user", columnList = "userId"),
        @Index(name = "idx_sys_user_sync_time", columnList = "syncTime"),
})
@Comment("账号同步记录")
@Getter
@Setter
public class SysUserSyncDO extends BaseModel {
    private static final long serialVersionUID = 2093866874512125359L;

    @Comment(value = "账户ID")
    @Column(nullable = false)
    private Long userId;

    @Comment(value = "外部系统编码")
    @Column(nullable = false)
    private String outerSysCode;

    @Column()
    @Comment("同步时间")
    private LocalDateTime syncTime;

    @Column()
    @Comment(value = "是否同步成功", defaultValue = "0")
    private Boolean syncSuccess;

    @Column()
    @Comment("同步结束时间")
    private LocalDateTime syncFinishTime;

    @Comment(value = "同步失败信息")
    @Column()
    @Lob
    private String failReason;

    @Comment(value = "同步失败的详细信息")
    @Column()
    @Lob
    private String failReasonDetail;

    @Comment(value = "回执信息")
    @Column()
    @Lob
    private String receipt;

    @Comment(value = "外部系统用户ID")
    @Column()
    private String outerUserId;

    @Comment(value = "外部系统用户编码")
    @Column()
    private String outerUserCode;

    @Comment(value = "同步接口地址")
    @Column()
    private String syncUrl;

    @Comment(value = "同步的数据信息")
    @Column()
    @Lob
    @Convert(converter = JsonStringMapConverter.class)
    private Map<String, Object> syncData;
}
