package com.elitescloud.cloudt.system.service.callback;

import com.elitescloud.cloudt.system.service.model.bo.SysOrgSaveBO;
import com.elitescloud.cloudt.system.service.model.bo.SysOuSaveBO;
import com.elitescloud.cloudt.system.service.model.entity.SysOrgDO;
import com.elitescloud.cloudt.system.service.model.entity.SysOuDO;

/**
 * 公司信息变化后的回调.
 *
 * @author Kaiser（wang shao）
 * @date 2023/2/2
 */
public interface OuChangedCallback {

    /**
     * 公司保存后的回调
     *
     * @param add    是否是新增操作
     * @param saveBO 保存参数
     * @param ouDO  公司entity
     */
    void onUpsert(boolean add, SysOuSaveBO saveBO, SysOuDO ouDO);

    /**
     * 启用、禁用
     *
     * @param ouId   公司ID
     * @param enabled 是否是启用操作
     */
    void onEnabled(Long ouId, boolean enabled);

    /**
     * 删除操作
     *
     * @param ouId 公司ID
     */
    void onDelete(Long ouId);
}
