package com.elitescloud.cloudt.system.service.callback;

import com.elitescloud.cloudt.system.service.model.bo.SysRoleSaveBO;
import com.elitescloud.cloudt.system.service.model.entity.SysRoleDO;

/**
 * 角色信息变化后的回调.
 *
 * @author Kaiser（wang shao）
 * 2022/9/29
 */
public interface RoleChangedCallback {

    /**
     * 角色保存后的回调
     *
     * @param add    是否是新增操作
     * @param saveBO 保存参数
     * @param roleDO 角色entity
     */
    void onUpsert(boolean add, SysRoleSaveBO saveBO, SysRoleDO roleDO);

    /**
     * 启用、禁用
     *
     * @param roleId  角色ID
     * @param enabled 是否是启用操作
     */
    void onEnabled(Long roleId, boolean enabled);

    /**
     * 删除操作
     *
     * @param roleDO 角色
     */
    void onDelete(SysRoleDO roleDO);
}
