package com.elitescloud.cloudt.system.service.common.constant;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * OpenApi状态.
 *
 * @author Kaiser（wang shao）
 * @date 2024/3/5
 */
public enum OpenApiStatusEnum {
    TO_UPDATE("待更新"),
    PREPARING("准备中"),
    UPDATING("更新中"),
    FINISHED("更新完成"),
    FAILED("更新失败"),
    ;

    private final String description;

    OpenApiStatusEnum(String description) {
        this.description = description;
    }

    public String getDescription() {
        return description;
    }

    private static final Map<String, OpenApiStatusEnum> ALL_MAP = Arrays.stream(OpenApiStatusEnum.values())
            .collect(Collectors.toMap(OpenApiStatusEnum::name, t -> t, (t1, t2) -> t1));

    /**
     * 转换enum
     *
     * @param name
     * @return
     */
    public static OpenApiStatusEnum parse(String name) {
        if (name == null) {
            return null;
        }
        return ALL_MAP.get(name);
    }
}
