package com.elitescloud.cloudt.system.service.model.bo;

import com.elitescloud.cloudt.system.service.common.constant.BelongType;
import lombok.Data;

/**
 * 角色保存信息.
 *
 * @author Kaiser（wang shao）
 * 2022/10/13
 */
@Data
public class SysRoleSaveBO {
    /**
     * 角色ID
     */
    private Long id;

    /**
     * 角色编码
     */
    private String code;

    /**
     * 角色名称
     */
    private String name;

    /**
     * 是否启用
     */
    private Boolean enabled;

    /**
     * 分组
     */
    private Long groupId;

    /**
     * 上级角色编码
     */
    private String parentCode;

    /**
     * 角色归属类型
     * {@link BelongType}
     */
    private String type;

    /**
     * 类型标识
     */
    private String typeId;

    /**
     * 业务标识，[UDC]cloudt-system:roleBusiness
     */
    private String businessKey;

    /**
     * 备注
     */
    private String remark;
}
