package com.elitescloud.cloudt.system.service.model.bo;

import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.Map;

/**
 * 第三方账号额信息.
 *
 * @author Kaiser（wang shao）
 * @date 2024/8/26
 */
@Getter
@Setter
public class ThirdPartAccountBO implements Serializable {
    private static final long serialVersionUID = -323068314692152664L;

    /**
     * 租户ID
     */
    private Long sysTenantId;

    /**
     * 业务类型
     */
    private String businessType;

    /**
     * 账户
     */
    private String account;

    /**
     * 账户类型
     */
    private String accountType;

    /**
     * 配置内容
     */
    private Map<String, Object> config;

    public Object getConfigValue(String key) {
        if (config == null) {
            return null;
        }
        return config.get(key);
    }
}
