package com.elitescloud.cloudt.system.service.model.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.DynamicInsert;

import javax.persistence.*;

/**
 * 业务对象的参数.
 * 当前从DO获取
 *
 * @author Kaiser（wang shao）
 * @date 2024/3/6
 */
@Entity
@Table(name = "sys_business_param", indexes = {
        @Index(name = "idx_business_param_openapi", columnList = "openApiCode"),
        @Index(name = "idx_business_param_obj", columnList = "businessObjectId"),
        @Index(name = "idx_business_param_objcode", columnList = "businessObjectCode"),
        @Index(name = "idx_business_param_operation", columnList = "businessOperationId"),
        @Index(name = "idx_business_param_relobj", columnList = "relatedBusinessObject"),
})

@Comment("业务对象的参数")
@DynamicInsert
@Getter
@Setter
public class SysBusinessParamDO extends BaseModel {
    private static final long serialVersionUID = 7528849790559465996L;
    public static final long DEFAULT_ID = -1;

    @Comment(value = "OpenApi的编码")
    @Column()
    private String openApiCode;

    @Comment(value = "业务对象ID")
    @Column(nullable = false)
    private Long businessObjectId;

    @Comment(value = "业务对象编码")
    @Column()
    private String businessObjectCode;

    @Comment(value = "业务操作ID")
    @Column()
    private Long businessOperationId;

    @Comment(value = "业务操作编码")
    @Column()
    private String businessOperationCode;

    @Comment(value = "业务操作参数ID")
    @Column()
    private Long businessOperationParamId;

    @Comment(value = "是否启用", defaultValue = "1")
    @Column()
    private Boolean enabled;

    @Comment(value = "是否为entity类的字段", defaultValue = "0")
    @Column()
    private Boolean entityField;

    @Comment(value = "entity类的名称")
    @Column()
    private String entityClassName;

    @Comment(value = "表名")
    @Column()
    private String tableName;

    @Comment(value = "字段名称")
    @Column(nullable = false)
    private String fieldName;

    @Comment(value = "列名称")
    @Column()
    private String columnName;

    @Comment(value = "字段描述")
    @Column()
    private String fieldDescription;

    @Comment(value = "自定义描述")
    @Column()
    private String customDescription;

    @Comment(value = "字段类型(java)")
    @Column()
    private String fieldJavaType;

    @Comment(value = "是否为子表", defaultValue = "0")
    @Column()
    private Boolean subTable;

    @Comment(value = "与主表关联的字段")
    @Column()
    private String relatedMasField;

    @Comment(value = "关联的主表中的字段")
    @Column()
    private String masField;

    @Comment(value = "是否可为空", defaultValue = "1")
    @Column()
    private Boolean nullable;

    @Comment(value = "是否单值", defaultValue = "1")
    @Column()
    private Boolean single;

    @Comment(value = "是否枚举类", defaultValue = "0")
    @Column()
    private Boolean enumeration;

    @Comment(value = "枚举值类型")
    @Column()
    private String enumType;

    @Comment(value = "顺序", defaultValue = "0")
    @Column()
    private Integer sortNo;

    @Comment(value = "关联业务对象标识")
    @Column()
    private String relatedBusinessObject;

    @Comment(value = "关联业务对象字段")
    @Column()
    private String relatedField;

    @Comment(value = "值列表")
    @Column()
    @Lob
    private String valuesJson;

    @Comment(value = "账号类型")
    @Column()
    private String userType;

    @Comment(value = "是否应于数据权限过滤", defaultValue = "1")
    @Column()
    private Boolean dataPermissionEnabled;

    @Comment(value = "是否应于字段权限过滤", defaultValue = "1")
    @Column()
    private Boolean fieldPermissionEnabled;

    @Comment(value = "是否为基础字段", defaultValue = "1")
    @Column()
    private Boolean baseField;

    @Comment(value = "是否过期", defaultValue = "0")
    @Column()
    private Boolean deprecated;
}
