package com.elitescloud.cloudt.system.service.model.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.DynamicInsert;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * 数据关系的分类.
 *
 * @author Kaiser（wang shao）
 * @date 2024/5/14
 */
@Entity
@Table(name = "sys_data_relation_cat", indexes = {
        @Index(name = "idx_datarelation_cat_dr", columnList = "drCode"),
})
@Comment("数据关系的分类")
@DynamicInsert
@Getter
@Setter
public class SysDataRelationCategoryDO extends BaseModel {
    private static final long serialVersionUID = -8447270504712842655L;

    @Comment(value = "数据关系编码")
    @Column(nullable = false)
    private String drCode;

    @Comment(value = "分类编码")
    @Column(nullable = false)
    private String catCode;

    @Comment(value = "分类名称")
    @Column(nullable = false)
    private String catName;

    @Comment(value = "是否启用", defaultValue = "1")
    @Column()
    private Boolean enabled;

    @Comment(value = "顺序", defaultValue = "0")
    @Column()
    private Integer sortNo;
}
