package com.elitescloud.cloudt.system.service.model.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.DynamicInsert;

import javax.persistence.*;

/**
 * 业务对象与数据关联的配置.
 *
 * @author Kaiser（wang shao）
 * @date 2024/5/14
 */
@Entity
@Table(name = "sys_data_relation_inst", indexes = {
        @Index(name = "idx_datarelation_inst_dr", columnList = "drCode"),
        @Index(name = "idx_datarelation_inst_datak", columnList = "dataKey"),
        @Index(name = "idx_datarelation_inst_cat", columnList = "catCode"),
        @Index(name = "idx_datarelation_inst_attr", columnList = "dataAttribute"),
        @Index(name = "idx_datarelation_inst_datakr", columnList = "refDataKey"),
})
@Comment("业务对象与数据关联的配置")
@DynamicInsert
@Getter
@Setter
public class SysDataRelationInstanceDO extends BaseModel {
    private static final long serialVersionUID = -8447270504712842655L;

    @Comment(value = "数据关系编码")
    @Column(nullable = false)
    private String drCode;

    @Comment(value = "分类编码")
    @Column()
    private String catCode;

    @Comment(value = "主数据的标识")
    @Column()
    private String dataKey;

    @Comment(value = "主数据的检索属性")
    @Column()
    private String dataAttribute;

    @Comment(value = "主数据的扩展信息")
    @Column()
    @Lob
    private String dataExtJson;

    @Comment(value = "关联数据的标识")
    @Column()
    private String refDataKey;

    @Comment(value = "关联数据的检索属性")
    @Column()
    private String refDataAttribute;

    @Comment(value = "关联数据的扩展信息")
    @Column()
    @Lob
    private String refDataExtJson;

    @Comment(value = "顺序", defaultValue = "0")
    @Column()
    private Integer sortNo;

}
