package com.elitescloud.cloudt.system.service.model.entity;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * 收藏菜单.
 * <p>
 * 个人级的收藏菜单，允许用户自定义快捷菜单
 *
 * @author Kaiser（wang shao）
 * 2022/9/15
 */
@Entity
@Table(name = "sys_menu_favor", indexes = {
        @Index(name = "idx_menu_favor_user", columnList = "userId")
})
@Comment("收藏菜单")
@Getter
@Setter
public class SysMenuFavorDO extends BaseModel {
    private static final long serialVersionUID = 3330354497544200172L;

    @Column(nullable = false)
    @Comment("用户ID")
    private Long userId;

    @Column(nullable = false)
    @Comment("原菜单编码")
    private String menuCode;

    @Column()
    @Comment("显示名称")
    private String menuName;

    @Column
    @Comment(value = "排序号", defaultValue = "0")
    private Integer sortNo;

    @Column
    @Comment(value = "是否启用", defaultValue = "1")
    private Boolean enabled;

    @Override
    public int hashCode() {
        return getId().hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof SysMenuFavorDO) {
            SysMenuFavorDO the = (SysMenuFavorDO) obj;
            if (getId() == null) {
                return the.getId() == null;
            }
            return getId().equals(the.getId());
        }
        return false;
    }
}
