package com.elitescloud.cloudt.system.service.model.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.system.constant.SysNoticeCategory;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.time.LocalDateTime;

/**
 * 系统公告.
 *
 * @author Kaiser（wang shao）
 * @date 2024/4/22
 */
@Entity
@Table(name = "sys_notice", indexes = {
        @Index(name = "idx_notice_title", columnList = "title"),
        @Index(name = "idx_notice_author", columnList = "authorId"),
        @Index(name = "idx_notice_category", columnList = "category"),
        @Index(name = "idx_notice_type", columnList = "noticeType"),
        @Index(name = "idx_notice_publish", columnList = "published"),
        @Index(name = "idx_notice_publishtime", columnList = "publishTime"),
})
@Comment("系统公告")
@DynamicInsert
@DynamicUpdate
@Getter
@Setter
public class SysNoticeDO extends BaseModel {
    private static final long serialVersionUID = -7345249920633951344L;

    @Comment(value = "标题")
    @Column(nullable = false)
    private String title;

    @Comment(value = "摘要")
    @Column()
    private String summaries;

    @Comment(value = "作者")
    @Column()
    private Long authorId;

    @Comment(value = "是否系统公告", defaultValue = "0")
    @Column()
    private Boolean sys;

    /**
     * 取值：{@link SysNoticeCategory}
     */
    @Comment(value = "分类，[UDC]cloudt-system:noticeCategory")
    @Column()
    private String category;

    @Comment(value = "公告类型")
    @Column()
    private String noticeType;

    @Comment(value = "是否置顶", defaultValue = "0")
    @Column()
    private Boolean top;

    @Comment(value = "是否已发布", defaultValue = "0")
    @Column()
    private Boolean published;

    @Comment(value = "发布时间")
    @Column()
    private LocalDateTime publishTime;

    @Comment(value = "修改时间")
    @Column()
    private LocalDateTime changeTime;

    @Comment(value = "公告内容ID")
    @Column()
    private Long txtId;

    @Comment(value = "附件标识，多个以逗号分隔")
    @Column()
    private String fileCodesStr;

    @Comment(value = "阅读量", defaultValue = "0")
    @Column()
    private Long readAmount;
}
