package com.elitescloud.cloudt.system.service.model.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.DynamicInsert;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2024/3/4
 */
@Entity
@Table(name = "sys_openapi_component_schema", indexes = {
        @Index(name = "idx_openapi_compsche_info", columnList = "openApiInfoId"),
        @Index(name = "idx_openapi_compsche_path", columnList = "schemaPath"),
})
@Comment("OpenAPI操作信息参数")
@DynamicInsert
@Getter
@Setter
public class SysOpenApiComponentSchemaDO extends BaseModel {
    private static final long serialVersionUID = 7544042051828427552L;

    @Comment(value = "openApi信息ID")
    @Column(nullable = false)
    private Long openApiInfoId;

    @Comment(value = "schema名称")
    @Column(nullable = false)
    private String schemaPath;

    @Comment(value = "schema类型")
    @Column()
    private String schemaType;

    @Comment(value = "原始数据的资源ID")
    @Column()
    private Long resourceId;
}
