package com.elitescloud.cloudt.system.service.model.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.system.service.common.constant.OpenApiStatusEnum;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.DynamicInsert;

import javax.persistence.*;
import java.time.LocalDateTime;

/**
 * OpenAPI信息.
 *
 * @author Kaiser（wang shao）
 * @date 2024/3/4
 */
@Entity
@Table(name = "sys_openapi_info", indexes = {
        @Index(name = "idx_openapi_info_code", columnList = "openApiCode", unique = true),
        @Index(name = "idx_openapi_info_app", columnList = "appCode"),
})
@Comment("OpenAPI信息")
@DynamicInsert
@Getter
@Setter
public class SysOpenApiInfoDO extends BaseModel {
    private static final long serialVersionUID = 5239493134767703411L;

    @Comment(value = "OpenApi编码")
    @Column()
    private String openApiCode;

    @Comment(value = "项目编码")
    @Column()
    private String project;

    @Comment(value = "项目名称")
    @Column()
    private String projectName;

    @Comment(value = "环境编码")
    @Column()
    private String env;

    @Comment(value = "环境名称")
    @Column()
    private String envName;

    @Comment(value = "应用编码")
    @Column()
    private String appCode;

    @Comment(value = "应用名称")
    @Column()
    private String appName;

    @Comment(value = "标题")
    @Column(nullable = false)
    private String title;

    @Comment(value = "描述")
    @Column()
    private String description;

    @Comment(value = "版本")
    @Column()
    private String version;

    @Comment(value = "OpenAPI构建时间")
    @Column()
    private LocalDateTime buildTime;

    @Comment(value = "项目版本")
    @Column()
    private String projectVersion;

    @Comment(value = "云梯架构版本")
    @Column()
    private String cloudtBootVersion;

    @Comment(value = "原始数据的资源ID")
    @Column()
    private Long resourceId;

    @Comment(value = "业务对象的资源ID")
    @Column()
    private Long businessResourceId;

    @Comment(value = "标签列表json")
    @Column()
    @Lob
    private String tagsJson;

    /**
     * 状态
     * <p>
     * 取值：{@link OpenApiStatusEnum}
     */
    @Comment(value = "OpenAPI状态")
    @Column()
    private String state;

    @Comment(value = "OpenAPI更新失败原因")
    @Column()
    @Lob
    private String failReason;

    @Comment(value = "开始更新时间")
    @Column()
    private LocalDateTime startUpdateTime;

    @Comment(value = "结束更新时间")
    @Column()
    private LocalDateTime endUpdateTime;

    /**
     * 业务对象状态
     * <p>
     * 取值：{@link OpenApiStatusEnum}
     */
    @Comment(value = "业务对象状态")
    @Column()
    private String businessObjectState;

    @Comment(value = "业务对象更新失败原因")
    @Column()
    @Lob
    private String businessObjectFailReason;

    @Comment(value = "开始更新时间")
    @Column()
    private LocalDateTime businessObjectStartUpdateTime;

    @Comment(value = "结束更新时间")
    @Column()
    private LocalDateTime businessObjectEndUpdateTime;
}
