package com.elitescloud.cloudt.system.service.model.entity;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.DynamicInsert;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.util.Objects;

/**
 * 租户的货币.
 *
 * @author Kaiser（wang shao）
 * @date 2023/1/31
 */
@Entity
@Table(name = "sys_tenant_currency", indexes = {
        @Index(name = "idx_tenant_currency_tenant", columnList = "sysTenantId"),
})
@Comment("租户的货币")
@DynamicInsert
@Getter
@Setter
public class SysTenantCurrencyDO extends BaseModel {
    private static final long serialVersionUID = 3129297762166938191L;

    @Column(nullable = false)
    @Comment("租户ID")
    private Long sysTenantId;

    @Column(nullable = false)
    @Comment("货币编码")
    private String currCode;

    @Column(nullable = false)
    @Comment(value = "是否启用", defaultValue = "0")
    private Boolean enabled;

    @Override
    public int hashCode() {
        return Objects.hashCode(getId());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof SysTenantCurrencyDO) {
            SysTenantCurrencyDO the = (SysTenantCurrencyDO) obj;
            if (getId() == null) {
                return the.getId() == null;
            }
            return getId().equals(the.getId());
        }
        return false;
    }
}
