package com.elitescloud.cloudt.system.service.model.entity;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;
import org.hibernate.Hibernate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.time.LocalDateTime;
import java.util.Objects;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * 2022/3/23
 */
@Entity
@Table(name = "sys_tenant_user", indexes = {
        @Index(name = "idx_tenant_user_user_id", columnList = "sysUserId"),
        @Index(name = "idx_tenant_user_tenant_id", columnList = "sysTenantId"),
        @Index(name = "idx_tenant_user_key", columnList = "sysUserId,sysTenantId")
})
@Comment("用户与租户的绑定关系")
@Getter
@Setter
@ToString
@Accessors(chain = true)
public class SysTenantUserDO extends BaseModel {

    private static final long serialVersionUID = -8268881842325186356L;

    @Comment("用户ID")
    @Column(nullable = false)
    private Long sysUserId;

    @Comment("租户ID")
    @Column(nullable = false)
    private Long sysTenantId;

    @Comment("绑定时间")
    @Column()
    private LocalDateTime bindTime;

    @Comment("上次登录时间")
    @Column()
    private LocalDateTime lastLoginTime;

    @Comment("账号过期时间")
    @Column()
    private LocalDateTime expiredTime;

    @Comment(value = "是否启用", defaultValue = "1")
    @Column()
    private Boolean enabled;

    @Comment(value = "是否是默认租户", defaultValue = "0")
    @Column()
    private Boolean def;

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || Hibernate.getClass(this) != Hibernate.getClass(o)) {
            return false;
        }
        SysTenantUserDO that = (SysTenantUserDO) o;
        return getId() != null && Objects.equals(getId(), that.getId());
    }

    @Override
    public int hashCode() {
        return getClass().hashCode();
    }
}
