package com.elitescloud.cloudt.system.service.model.entity;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.DynamicInsert;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.util.Objects;

/**
 * 导入导出的文件记录.
 *
 * @author Kaiser（wang shao）
 * @date 2/15/2023
 */
@Entity
@Table(name = "sys_tmpl_import_file", indexes = {
        @Index(name = "idx_tmpl_import_file_tmpl_id", columnList = "tmplId"),
        @Index(name = "idx_tmpl_import_file_record_id", columnList = "recordId"),
})
@Comment("导入导出的文件记录")
@DynamicInsert
@Getter
@Setter
public class SysTmplImportFileDO extends BaseModel {
    private static final long serialVersionUID = -7705206061589876246L;

    @Column(nullable = false)
    @Comment("导入导出记录ID")
    private Long recordId;

    @Column(nullable = false)
    @Comment("模板文件ID")
    private Long tmplId;

    @Column(nullable = false)
    @Comment("文件编码")
    private String fileCode;

    @Column()
    @Comment(value = "文件顺序", defaultValue = "0")
    private Integer fileOrder;

    @Column()
    @Comment("文件名称")
    private String fileName;

    @Override
    public int hashCode() {
        return Objects.hashCode(getId());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof SysTmplImportFileDO) {
            SysTmplImportFileDO the = (SysTmplImportFileDO) obj;
            if (getId() == null) {
                return the.getId() == null;
            }
            return getId().equals(the.getId());
        }
        return false;
    }
}
