package com.elitescloud.cloudt.system.service.model.vo;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.boot.common.param.TreeRespParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 通用的行政区域树.
 *
 * @author Kaiser（wang shao）
 * @date 2/23/2023
 */
@ApiModel(description = "行政区域树")
@Data
public class CommonAreaTreeRespVO extends TreeRespParam<CommonAreaTreeRespVO> {
    private static final long serialVersionUID = -1459353393960863322L;

    /**
     * 子节点数量
     */
    @ApiModelProperty(value = "子节点数量", position = 21)
    private Integer childrenNum;

    @Override
    public Boolean getHasChildren() {
        if (CollUtil.isNotEmpty(getChildren())) {
            return true;
        }
        return childrenNum != null && childrenNum > 0;
    }
}
