package com.elitescloud.cloudt.system.service.util;

import cn.hutool.core.lang.Assert;
import cn.zhxu.bs.param.OrderBy;
import cn.zhxu.bs.util.MapBuilder;
import com.elitescloud.cloudt.common.base.param.OrderItem;

import java.util.List;

/**
 * @author : chen.niu
 * @description :
 * @date : 2023/5/26 20:55
 */
public class BeanSearcherUtils {
    /***
     * 动态排序私有方法
     * todo未来转成公共
     * @param orders 前端排序入参
     * @param mapBuilder 构造器
     * @param defaultOrder 如果前端没有传参，默认排序参数
     */
    public static void setParamsOrderBy(List<OrderItem> orders, MapBuilder mapBuilder,
                                         OrderBy defaultOrder) {
        Assert.notNull(defaultOrder,"默认排序不能空");
        if(orders==null){
            mapBuilder.orderBy(defaultOrder.getSort(), defaultOrder.getOrder());
            return;
        }
        for (OrderItem orderItem : orders) {
            if (orderItem != null && !orderItem.getColumn().isBlank()) {
                if (orderItem.isAsc()) {
                    mapBuilder.orderBy(orderItem.getColumn()).asc();
                }
                else {
                    mapBuilder.orderBy(orderItem.getColumn()).desc();
                }
            } else {
                mapBuilder.orderBy(defaultOrder.getSort(), defaultOrder.getOrder());
            }
        }
    }
}
