package com.elitescloud.cloudt.system.service.vo;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @author Chris
 * 2021-07-19
 */
@ApiModel("用户分页VO")
@Data
public class SysUserPagingVO implements Serializable {

    private static final long serialVersionUID = -5841605288262355318L;

    /**
     * 用户ID
     */
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("用户ID")
    private Long id;

    /**
     * 用户账号
     */
    @ApiModelProperty("用户账号")
    private String username;

    /**
     * 用户姓氏
     */
    @ApiModelProperty("用户姓氏")
    private String lastName;

    /**
     * 用户名称
     */
    @ApiModelProperty("用户名称")
    private String firstName;

    /**
     * 手机号
     */
    @ApiModelProperty("手机号")
    private String mobile;

    /**
     * 电子邮箱
     */
    @ApiModelProperty("电子邮箱")
    private String email;

    /**
     * 角色名称列表
     */
    @ApiModelProperty("应用角色名称列表")
    private String roleNames;

    /**
     * 角色名称列表
     */
    @ApiModelProperty("数据角色名称列表")
    private String dataRoleNames;

    /**
     * 流程角色名称列表
     */
    @ApiModelProperty("流程角色名称列表")
    private String flowRoleNames;

    /**
     * 用户账号启用状态
     */
    @ApiModelProperty("用户账号启用状态")
    private Boolean enabled;

    /**
     * 用户所属公司ID
     */
    @ApiModelProperty("用户所属公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;

    /**
     * 用户所属公司编号
     */
    @ApiModelProperty("用户所属公司编号")
    private String ouCode;

    /**
     * 用户所属公司名称
     */
    @ApiModelProperty("用户所属公司名称")
    private String ouName;

    @ApiModelProperty("所属租户ID")
    private Long tenantId;

    @ApiModelProperty("所属租户名称")
    private String tenantName;

    /**
     * 用户所属组织ID
     */
    @ApiModelProperty("用户所属组织ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long buId;
}
