/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.common.constant;

import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.cloudt.system.vo.SysUdcVO;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

public enum PlatformAppTypeEnum {
    APP_TYPE_SYS("SYS_PLATFORM", "APP_TYPE", "APP\u7c7b\u578b", "\u7cfb\u7edf", 1),
    APP_TYPE_BUS("SYS_PLATFORM", "APP_TYPE", "APP\u7c7b\u578b", "\u4e1a\u52a1", 2);

    private final String domainCode;
    private final String udcCode;
    private final String udcName;
    private final String description;
    private final int sortNo;
    private static final Map<String, PlatformAppTypeEnum> ALL;

    private PlatformAppTypeEnum(String domainCode, String udcCode, String udcName, String description, int sortNo) {
        this.domainCode = domainCode;
        this.sortNo = sortNo;
        this.udcCode = udcCode;
        this.udcName = udcName;
        this.description = description;
    }

    public SysUdcVO getUdcVO() {
        SysUdcVO sysUdcVO = new SysUdcVO();
        sysUdcVO.setDomainCode(this.domainCode);
        sysUdcVO.setUdcCode(this.udcCode);
        sysUdcVO.setUdcName(this.udcName);
        sysUdcVO.setUdcVal(this.name());
        sysUdcVO.setValDesc(this.description);
        sysUdcVO.setValSortNo(Integer.valueOf(this.sortNo));
        sysUdcVO.setId(Long.valueOf(this.sortNo));
        return sysUdcVO;
    }

    public String getDescription() {
        return this.description;
    }

    public static PlatformAppTypeEnum parse(String value) {
        if (CharSequenceUtil.isBlank((CharSequence)value)) {
            return null;
        }
        return ALL.get(value);
    }

    static {
        ALL = Arrays.stream(PlatformAppTypeEnum.values()).collect(Collectors.toMap(Enum::name, t -> t, (t1, t2) -> t1));
    }
}

