/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.model.entity;

import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.common.annotation.BusinessParam;
import com.elitescloud.boot.constant.Gender;
import com.elitescloud.boot.core.support.customfield.common.CustomFieldBaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import java.time.LocalDate;
import java.time.LocalDateTime;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Lob;
import javax.persistence.Table;
import org.hibernate.annotations.DynamicUpdate;
import org.springframework.util.StringUtils;

@Entity
@Table(name="sys_employee", indexes={@Index(name="idx_sys_emp_user_id", columnList="userId"), @Index(name="idx_sys_emp_root_org_id", columnList="rootOrgId"), @Index(name="idx_sys_emp_code", columnList="code"), @Index(name="idx_sys_emp_type", columnList="type"), @Index(name="idx_sys_emp_email", columnList="email")})
@Comment(value="\u5458\u5de5")
@DynamicUpdate
public class SysEmployeeDO
extends CustomFieldBaseModel {
    private static final long serialVersionUID = 3344534498352255891L;
    @BusinessParam(relatedBusinessObject="Sys_User:\u8d26\u53f7", dataPermissionEnabled=true, fieldPermissionEnabled=false)
    @Column(nullable=false)
    @Comment(value="\u7528\u6237\u8d26\u53f7ID")
    private Long userId;
    @BusinessParam(relatedBusinessObject="Sys_Org:\u7ec4\u7ec7", dataPermissionEnabled=true, fieldPermissionEnabled=false)
    @Column(nullable=false)
    @Comment(value="\u6839\u7ec4\u7ec7ID")
    private Long rootOrgId;
    @BusinessParam(relatedBusinessObject="Sys_User:\u8d26\u53f7", relatedField="username", dataPermissionEnabled=true, fieldPermissionEnabled=false)
    @Comment(value="\u7528\u6237\u8d26\u53f7")
    @Column
    private String username;
    @Comment(value="\u59d3\u540d-\u59d3\u6c0f")
    @Column
    private String lastName;
    @Comment(value="\u59d3\u540d-\u540d\u5b57")
    @Column
    private String firstName;
    @Column
    @Comment(value="\u6027\u522b\uff0c\uff08male-\u7537\uff0cfemale-\u5973\uff0csecret-\u4fdd\u5bc6\uff09")
    private String gender;
    @Column
    @Comment(value="\u6635\u79f0")
    private String nickName;
    @Column
    @Comment(value="\u751f\u65e5")
    private LocalDate birthDate;
    @Column
    @Comment(value="\u5458\u5de5\u7f16\u53f7")
    @BusinessParam(dataPermissionEnabled=false, fieldPermissionEnabled=true)
    private String code;
    @BusinessParam(relatedBusinessObject="SysPlatform_Udc:\u5e73\u53f0UDC", relatedField="udcValueCode", values={"cloudt-system", "employeeType"})
    @Column
    @Comment(value="\u5458\u5de5\u7c7b\u578b\uff0c[UDC]cloudt-system:employeeType")
    private String type;
    @Column
    @Comment(value="\u804c\u52a1")
    private String duty;
    @Column
    @Comment(value="\u5458\u5de5\u7167\u7247")
    private String photo;
    @Column
    @Comment(value="\u5408\u540c\u8d77\u59cb\u65f6\u95f4")
    private LocalDateTime contractStartTime;
    @Column
    @Comment(value="\u5408\u540c\u622a\u6b62\u65f6\u95f4")
    private LocalDateTime contractEndTime;
    @Column
    @Comment(value="\u5165\u804c\u65f6\u95f4")
    private LocalDateTime joinTime;
    @Comment(value="\u529e\u516c\u7535\u8bdd")
    @Column
    private String phone;
    @Comment(value="\u5de5\u4f5c\u90ae\u7bb1")
    @Column
    private String emailWork;
    @Comment(value="\u624b\u673a\u53f7")
    @Column
    private String mobile;
    @Comment(value="\u4e2a\u4eba\u90ae\u7bb1")
    @Column
    private String email;
    @Column
    @Comment(value="\u8eab\u4efd\u8bc1\u53f7")
    private String idCard;
    @Column
    @Comment(value="\u79bb\u804c\u65f6\u95f4")
    private LocalDateTime leaveTime;
    @Column
    @Comment(value="\u662f\u5426\u5728\u804c", defaultValue="1")
    @BusinessParam(dataPermissionEnabled=true, fieldPermissionEnabled=true)
    private Boolean served;
    @Column
    @Comment(value="\u662f\u5426\u542f\u7528", defaultValue="1")
    @BusinessParam(dataPermissionEnabled=true, fieldPermissionEnabled=true)
    private Boolean enabled;
    @Column
    @Comment(value="\u987a\u5e8f", defaultValue="1")
    private Integer sortNo;
    @Column
    @Comment(value="\u56fd\u5bb6\u7f16\u7801")
    private String countryCode;
    @Column
    @Comment(value="\u7701\u7f16\u7801")
    private String provinceCode;
    @Column
    @Comment(value="\u5e02\u7f16\u7801")
    private String cityCode;
    @Column
    @Comment(value="\u53bf\u7f16\u7801")
    private String countyCode;
    @Column
    @Comment(value="\u8be6\u7ec6\u5730\u5740")
    private String address;
    @Column
    @Comment(value="\u4e2a\u6027\u7b7e\u540d")
    private String personalSign;
    @Comment(value="\u7528\u6237\u5934\u50cf\u5730\u5740\uff0c\u53ef\u76f4\u63a5\u8bbf\u95ee\uff0c\u5982\u5fae\u4fe1\u5934\u50cf\u5730\u5740\u7b49")
    @Lob
    private String avatarUrl;
    @Comment(value="\u7528\u6237\u5934\u50cf\u5728\u6587\u4ef6\u670d\u52a1\u5668\u4e2d\u7684\u6807\u8bc6")
    @Column
    private String avatarCode;

    public String getFullName() {
        if (!StringUtils.hasText((String)this.lastName)) {
            return this.firstName;
        }
        return this.lastName + CharSequenceUtil.blankToDefault((CharSequence)this.firstName, (String)"");
    }

    public String getGenderName() {
        if (CharSequenceUtil.isBlank((CharSequence)this.getGender())) {
            return null;
        }
        return new Gender(this.getGender()).getDescription();
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof SysEmployeeDO) {
            SysEmployeeDO the = (SysEmployeeDO)((Object)obj);
            if (this.getId() == null) {
                return the.getId() == null;
            }
            return this.getId().equals(the.getId());
        }
        return false;
    }

    public Long getUserId() {
        return this.userId;
    }

    public Long getRootOrgId() {
        return this.rootOrgId;
    }

    public String getUsername() {
        return this.username;
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getGender() {
        return this.gender;
    }

    public String getNickName() {
        return this.nickName;
    }

    public LocalDate getBirthDate() {
        return this.birthDate;
    }

    public String getCode() {
        return this.code;
    }

    public String getType() {
        return this.type;
    }

    public String getDuty() {
        return this.duty;
    }

    public String getPhoto() {
        return this.photo;
    }

    public LocalDateTime getContractStartTime() {
        return this.contractStartTime;
    }

    public LocalDateTime getContractEndTime() {
        return this.contractEndTime;
    }

    public LocalDateTime getJoinTime() {
        return this.joinTime;
    }

    public String getPhone() {
        return this.phone;
    }

    public String getEmailWork() {
        return this.emailWork;
    }

    public String getMobile() {
        return this.mobile;
    }

    public String getEmail() {
        return this.email;
    }

    public String getIdCard() {
        return this.idCard;
    }

    public LocalDateTime getLeaveTime() {
        return this.leaveTime;
    }

    public Boolean getServed() {
        return this.served;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public Integer getSortNo() {
        return this.sortNo;
    }

    public String getCountryCode() {
        return this.countryCode;
    }

    public String getProvinceCode() {
        return this.provinceCode;
    }

    public String getCityCode() {
        return this.cityCode;
    }

    public String getCountyCode() {
        return this.countyCode;
    }

    public String getAddress() {
        return this.address;
    }

    public String getPersonalSign() {
        return this.personalSign;
    }

    public String getAvatarUrl() {
        return this.avatarUrl;
    }

    public String getAvatarCode() {
        return this.avatarCode;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public void setRootOrgId(Long rootOrgId) {
        this.rootOrgId = rootOrgId;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public void setGender(String gender) {
        this.gender = gender;
    }

    public void setNickName(String nickName) {
        this.nickName = nickName;
    }

    public void setBirthDate(LocalDate birthDate) {
        this.birthDate = birthDate;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setDuty(String duty) {
        this.duty = duty;
    }

    public void setPhoto(String photo) {
        this.photo = photo;
    }

    public void setContractStartTime(LocalDateTime contractStartTime) {
        this.contractStartTime = contractStartTime;
    }

    public void setContractEndTime(LocalDateTime contractEndTime) {
        this.contractEndTime = contractEndTime;
    }

    public void setJoinTime(LocalDateTime joinTime) {
        this.joinTime = joinTime;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public void setEmailWork(String emailWork) {
        this.emailWork = emailWork;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setIdCard(String idCard) {
        this.idCard = idCard;
    }

    public void setLeaveTime(LocalDateTime leaveTime) {
        this.leaveTime = leaveTime;
    }

    public void setServed(Boolean served) {
        this.served = served;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public void setSortNo(Integer sortNo) {
        this.sortNo = sortNo;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public void setProvinceCode(String provinceCode) {
        this.provinceCode = provinceCode;
    }

    public void setCityCode(String cityCode) {
        this.cityCode = cityCode;
    }

    public void setCountyCode(String countyCode) {
        this.countyCode = countyCode;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public void setPersonalSign(String personalSign) {
        this.personalSign = personalSign;
    }

    public void setAvatarUrl(String avatarUrl) {
        this.avatarUrl = avatarUrl;
    }

    public void setAvatarCode(String avatarCode) {
        this.avatarCode = avatarCode;
    }
}

