/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.repo;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.boot.jpa.common.BaseTreeRepoProc;
import com.elitescloud.boot.util.ObjUtil;
import com.elitescloud.cloudt.system.dto.req.SysAreaQueryDTO;
import com.elitescloud.cloudt.system.service.model.entity.QSysPlatformAreaDO;
import com.elitescloud.cloudt.system.service.model.entity.SysPlatformAreaDO;
import com.elitescloud.cloudt.system.service.model.vo.CommonAreaQueryVO;
import com.elitescloud.cloudt.system.service.model.vo.CommonAreaTreeRespVO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.core.types.dsl.NumberExpression;
import com.querydsl.core.types.dsl.SimpleExpression;
import com.querydsl.core.types.dsl.StringExpression;
import com.querydsl.jpa.impl.JPAQuery;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.springframework.stereotype.Repository;
import org.springframework.util.StringUtils;

@Repository
public class AreaRepoProc
extends BaseTreeRepoProc<SysPlatformAreaDO> {
    private static final QSysPlatformAreaDO QDO = QSysPlatformAreaDO.sysPlatformAreaDO;

    public AreaRepoProc() {
        super((EntityPathBase)QDO);
    }

    public void updateCodePath(long id, @NotBlank String codePath) {
        this.jpaQueryFactory.update((EntityPath)QDO).set((Path)AreaRepoProc.QDO.codePath, (Object)codePath).where(new Predicate[]{AreaRepoProc.QDO.id.eq((Object)id)}).execute();
    }

    public void deleteChildren(String pcode, Long pid) {
        if (pid == null && CharSequenceUtil.isNotBlank((CharSequence)pcode)) {
            pid = this.getIdByValue((Path)AreaRepoProc.QDO.areaCode, pcode);
        }
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder().and((Predicate)super.predicateForChildren(pid)).andNe(AreaRepoProc.QDO.id, (Object)pid).build();
        super.delete(predicate);
    }

    public boolean existsCode(@NotBlank String code) {
        return super.exists((Path)AreaRepoProc.QDO.areaCode, (Object)code);
    }

    public boolean existsCode(@NotBlank String areaCode, Long id) {
        return super.exists((Path)AreaRepoProc.QDO.areaCode, (Object)areaCode, id);
    }

    public String getCode(long id) {
        return (String)super.getValue((Path)AreaRepoProc.QDO.areaCode, id);
    }

    public Long getId(@NotBlank String areaCode) {
        return super.getIdByValue((Path)AreaRepoProc.QDO.areaCode, (Object)areaCode);
    }

    public String getAreaName(long id) {
        return (String)super.getValue((Path)AreaRepoProc.QDO.areaName, id);
    }

    public String getAreaName(@NotBlank String areaCode) {
        return (String)super.getValueByValue((Path)AreaRepoProc.QDO.areaName, (Path)AreaRepoProc.QDO.areaCode, (Object)areaCode);
    }

    public String getCodePath(long id) {
        return (String)super.getValue((Path)AreaRepoProc.QDO.codePath, id);
    }

    public String getCodePath(@NotBlank String areaCode) {
        return (String)super.getValueByValue((Path)AreaRepoProc.QDO.codePath, (Path)AreaRepoProc.QDO.areaCode, (Object)areaCode);
    }

    public List<SysPlatformAreaDO> listByCode(@NotEmpty Collection<String> codes) {
        return super.getListByValue((Path)AreaRepoProc.QDO.areaCode, codes, new OrderSpecifier[0]);
    }

    public List<SysPlatformAreaDO> listByCodeOrName(@NotEmpty Collection<String> codeOrNames) {
        return super.getList((Predicate)AreaRepoProc.QDO.areaCode.in(codeOrNames).or((Predicate)AreaRepoProc.QDO.areaName.in(codeOrNames)), new OrderSpecifier[0]);
    }

    public List<SysPlatformAreaDO> listByCodeOrNameFuzzily(@NotEmpty Collection<String> codeOrNames) {
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder().andRightLike((StringExpression)AreaRepoProc.QDO.areaCode, codeOrNames).andRightLike((StringExpression)AreaRepoProc.QDO.areaName, codeOrNames).buildOr();
        return super.getList(predicate, new OrderSpecifier[0]);
    }

    public List<SysPlatformAreaDO> listByParentAreaCode(@NotBlank String parentAreaCode) {
        return super.getListByValue((Path)AreaRepoProc.QDO.parentAreaCode, (Object)parentAreaCode, new OrderSpecifier[0]);
    }

    public List<SysPlatformAreaDO> queryList(@NotNull SysAreaQueryDTO queryDTO) {
        Set codeOrNames = CollUtil.isEmpty((Collection)queryDTO.getCodeOrNames()) ? Collections.emptySet() : queryDTO.getCodeOrNames().stream().filter(StringUtils::hasText).collect(Collectors.toSet());
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder().andEq((SimpleExpression)AreaRepoProc.QDO.areaCode, (Object)queryDTO.getAreaCode()).andIn((SimpleExpression)AreaRepoProc.QDO.areaCode, (Collection)queryDTO.getAreaCodes()).andEq((SimpleExpression)AreaRepoProc.QDO.parentAreaCode, (Object)queryDTO.getParentAreaCode()).andEq((SimpleExpression)AreaRepoProc.QDO.areaType, (Object)queryDTO.getAreaType()).andEq((SimpleExpression)AreaRepoProc.QDO.enabled, (Object)queryDTO.getEnabled()).andEq((SimpleExpression)AreaRepoProc.QDO.areaName, (Object)queryDTO.getAreaName()).andIn((SimpleExpression)AreaRepoProc.QDO.areaName, (Collection)queryDTO.getAreaNames()).andRightLike((StringExpression)AreaRepoProc.QDO.areaName, queryDTO.getAreaNameRightLike()).andLike((StringExpression)AreaRepoProc.QDO.pinyin, queryDTO.getPinyin()).and(StringUtils.hasText((String)queryDTO.getCodeOrName()), () -> AreaRepoProc.QDO.areaCode.eq((Object)queryDTO.getCodeOrName()).or((Predicate)AreaRepoProc.QDO.areaName.eq((Object)queryDTO.getCodeOrName()))).and(CollUtil.isNotEmpty(codeOrNames), () -> AreaRepoProc.QDO.areaCode.in((Collection)codeOrNames).or((Predicate)AreaRepoProc.QDO.areaName.in((Collection)codeOrNames))).build();
        return super.getList(predicate, new OrderSpecifier[0]);
    }

    public List<CommonAreaTreeRespVO> queryList(@NotNull CommonAreaQueryVO queryVO) {
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder().andEq(AreaRepoProc.QDO.pId, (Object)queryVO.getPid()).andEq((SimpleExpression)AreaRepoProc.QDO.parentAreaCode, (Object)queryVO.getPcode()).andEq((SimpleExpression)AreaRepoProc.QDO.areaType, (Object)queryVO.getAreaType()).andLike((StringExpression)AreaRepoProc.QDO.areaName, queryVO.getName()).andEq(true, (SimpleExpression)AreaRepoProc.QDO.enabled, (Object)true).build();
        NumberExpression pathChildrenNum = AreaRepoProc.QDO.rgt.subtract((Expression)AreaRepoProc.QDO.lft.add((Number)1)).divide((Number)2).as("childrenNum");
        return ((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(CommonAreaTreeRespVO.class, (Expression[])new Expression[]{AreaRepoProc.QDO.id, AreaRepoProc.QDO.areaCode.as("code"), AreaRepoProc.QDO.areaName.as("name"), AreaRepoProc.QDO.sortNo, AreaRepoProc.QDO.pId.as("parentId"), AreaRepoProc.QDO.parentAreaCode.as("parentCode"), pathChildrenNum})).from((EntityPath)QDO)).where(predicate)).orderBy(AreaRepoProc.QDO.sortNo.asc())).fetch();
    }

    public List<CommonAreaTreeRespVO> queryList(String pcode, Long pid) {
        if (pid == null && CharSequenceUtil.isNotBlank((CharSequence)pcode)) {
            pid = this.getIdByValue((Path)AreaRepoProc.QDO.areaCode, pcode);
        }
        return this.getTree(pid, null, t -> Boolean.TRUE.equals(t.getEnabled()), t -> {
            CommonAreaTreeRespVO respVO = new CommonAreaTreeRespVO();
            respVO.setId(t.getId());
            respVO.setCode(t.getAreaCode());
            respVO.setName(CharSequenceUtil.blankToDefault((CharSequence)t.getShortName(), (String)t.getAreaName()));
            respVO.setSortNo((Integer)ObjUtil.defaultIfNull((Object)t.getSortNo(), (Object)0));
            respVO.setParentId(t.getPId());
            respVO.setParentCode(t.getParentAreaCode());
            return respVO;
        });
    }

    public List<SysPlatformAreaDO> queryAllList(String pcode, Long pid) {
        if (pid == null && CharSequenceUtil.isNotBlank((CharSequence)pcode)) {
            pid = this.getIdByValue((Path)AreaRepoProc.QDO.areaCode, pcode);
        }
        return this.getTree(pid, null, null, t -> t);
    }

    public Map<String, String> getCodeAndName(@NotEmpty Collection<String> areaCodes) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(new Expression[]{AreaRepoProc.QDO.areaCode, AreaRepoProc.QDO.areaName}).from((EntityPath)QDO)).where((Predicate)AreaRepoProc.QDO.areaCode.in(areaCodes))).fetch().stream().collect(Collectors.toMap(t -> (String)t.get((Expression)AreaRepoProc.QDO.areaCode), t -> (String)t.get((Expression)AreaRepoProc.QDO.areaName), (t1, t2) -> t1));
    }

    public Map<String, Long> getIdAndCode() {
        return ((JPAQuery)this.jpaQueryFactory.select(new Expression[]{AreaRepoProc.QDO.id, AreaRepoProc.QDO.areaCode}).from((EntityPath)QDO)).fetch().stream().collect(Collectors.toMap(t -> (String)t.get((Expression)AreaRepoProc.QDO.areaCode), t -> (Long)t.get(AreaRepoProc.QDO.id), (t1, t2) -> t1));
    }

    public Map<Long, String> getIdAndCodePathByCodePath(@NotBlank String codePath) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(new Expression[]{AreaRepoProc.QDO.id, AreaRepoProc.QDO.codePath}).from((EntityPath)QDO)).where((Predicate)AreaRepoProc.QDO.codePath.like(codePath + "|%"))).fetch().stream().collect(Collectors.toMap(t -> (Long)t.get(AreaRepoProc.QDO.id), t -> (String)t.get((Expression)AreaRepoProc.QDO.codePath), (t1, t2) -> t1));
    }
}

