/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.repo;

import com.elitescloud.boot.common.param.CodeNameParam;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.system.service.model.entity.QSysPlatformAppDO;
import com.elitescloud.cloudt.system.service.model.entity.QSysTenantAppDO;
import com.elitescloud.cloudt.system.service.model.entity.SysTenantAppDO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.jpa.JPAExpressions;
import com.querydsl.jpa.impl.JPAQuery;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.constraints.NotBlank;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;

@Repository
public class SysTenantAppRepoProc
extends BaseRepoProc<SysTenantAppDO> {
    private static final QSysTenantAppDO QDO = QSysTenantAppDO.sysTenantAppDO;
    private static final QSysPlatformAppDO QDO_APP = QSysPlatformAppDO.sysPlatformAppDO;

    public SysTenantAppRepoProc() {
        super((EntityPathBase)QDO);
    }

    public void deleteByApp(@NotBlank String appCode) {
        super.deleteByValue((Path)SysTenantAppRepoProc.QDO.appCode, (Object)appCode);
    }

    public void deleteByTenant(long tenantId) {
        super.deleteByValue(SysTenantAppRepoProc.QDO.sysTenantId, (Object)tenantId);
    }

    public void deleteByTenantAndAppCode(Long sysTenantId, Set<String> appCodes) {
        this.jpaQueryFactory.delete((EntityPath)QDO).where(new Predicate[]{SysTenantAppRepoProc.QDO.sysTenantId.eq((Object)sysTenantId).and((Predicate)SysTenantAppRepoProc.QDO.appCode.in(appCodes))}).execute();
    }

    public Set<String> getAppCode(Long sysTenantId) {
        return new HashSet<String>(((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)SysTenantAppRepoProc.QDO.appCode).from((EntityPath)QDO)).where((Predicate)SysTenantAppRepoProc.QDO.sysTenantId.eq((Object)sysTenantId))).fetch());
    }

    public Map<Long, Set<String>> getAppCodes(Collection<Long> tenantIds) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(new Expression[]{SysTenantAppRepoProc.QDO.sysTenantId, SysTenantAppRepoProc.QDO.appCode}).from((EntityPath)QDO)).where(CollectionUtils.isEmpty(tenantIds) ? null : SysTenantAppRepoProc.QDO.sysTenantId.in(tenantIds))).fetch().stream().collect(Collectors.groupingBy(t -> (Long)t.get(SysTenantAppRepoProc.QDO.sysTenantId), Collectors.collectingAndThen(Collectors.toList(), t -> t.stream().map(tt -> (String)tt.get((Expression)SysTenantAppRepoProc.QDO.appCode)).collect(Collectors.toSet()))));
    }

    public Map<Long, Set<String>> getAppCodeAll() {
        return ((JPAQuery)this.jpaQueryFactory.select(new Expression[]{SysTenantAppRepoProc.QDO.sysTenantId, SysTenantAppRepoProc.QDO.appCode}).from((EntityPath)QDO)).fetch().stream().collect(Collectors.groupingBy(t -> (Long)t.get(SysTenantAppRepoProc.QDO.sysTenantId), Collectors.collectingAndThen(Collectors.toList(), t -> t.stream().map(tt -> (String)tt.get((Expression)SysTenantAppRepoProc.QDO.appCode)).collect(Collectors.toSet()))));
    }

    public List<CodeNameParam> getAppOfTenant(long sysTenantId) {
        return ((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.qBeanCodeName()).from((EntityPath)QDO_APP)).where((Predicate)SysTenantAppRepoProc.QDO_APP.appCode.in((SubQueryExpression)JPAExpressions.select((Expression)SysTenantAppRepoProc.QDO.appCode).from(new EntityPath[]{QDO}).where(new Predicate[]{SysTenantAppRepoProc.QDO.sysTenantId.eq((Object)sysTenantId)})).and((Predicate)SysTenantAppRepoProc.QDO_APP.appState.eq(Boolean.valueOf(true))))).orderBy(SysTenantAppRepoProc.QDO_APP.appOrder.desc())).fetch();
    }

    private QBean<CodeNameParam> qBeanCodeName() {
        return Projections.bean(CodeNameParam.class, (Expression[])new Expression[]{SysTenantAppRepoProc.QDO_APP.appCode, SysTenantAppRepoProc.QDO_APP.appName});
    }
}

