package com.elitescloud.cloudt.tenant.config.support;

import com.elitescloud.boot.tenant.client.support.TenantProviderService;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.dto.SysTenantDTO;
import com.elitescloud.cloudt.tenant.service.SysTenantQueryService;

import java.util.List;

/**
 * 租户查询服务.
 *
 * @author Kaiser（wang shao）
 * @date 4/4/2023
 */
public class SystemTenantProviderService implements TenantProviderService {

    private final SysTenantQueryService tenantService;

    public SystemTenantProviderService(SysTenantQueryService tenantService) {
        this.tenantService = tenantService;
    }

    @Override
    public ApiResult<List<SysTenantDTO>> allTenants() {
        return tenantService.allTenants();
    }
}
