package com.elitescloud.cloudt.tenant.model.entity;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * <p>
 *  数据源实体类：作用
 *      1.后端代码生成
 *      2.租户数据隔离（数据库级别）
 * <p>
 *
 * @author Roman.Zhang
 * 2022/2/16
 */
@Entity
@Table(name = "sys_database_source")
@Comment("数据源表")
@DynamicUpdate
@Getter
@Setter
@ToString
@Accessors(chain = true)
public class SysDatabaseSourceDO extends BaseModel implements Serializable {
    private static final long serialVersionUID = -9108782966426923730L;

    /**
     * 名称
     */
    @ApiModelProperty(value = "数据源名称")
    @Comment("数据源名称")
    @Column(nullable = false, unique = true)
    private String dbsName;
    /**
     * 驱动类
     */
    @ApiModelProperty(value = "驱动类")
    @Comment("驱动类")
    @Column(nullable = false, unique = true)
    private String dbsDriverClass;
    /**
     * 连接地址
     */
    @ApiModelProperty(value = "连接地址")
    @Comment("连接地址")
    @Column(nullable = false, unique = true)
    private String dbsUrl;
    /**
     * 用户名
     */
    @ApiModelProperty(value = "用户名")
    @Comment("驱动类")
    @Column(nullable = false, unique = true)
    private String dbsUsername;
    /**
     * 密码
     */
    @ApiModelProperty(value = "密码")
    @Comment("驱动类")
    @Column(nullable = false, unique = true)
    private String dbsPassword;
}
