/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.tenant.controller;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.service.model.vo.SysUserTenantVO;
import com.elitescloud.cloudt.tenant.service.ApiTenantService;
import com.elitescloud.cloudt.tenant.service.SysTenantMngService;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@ResponseBody
@RequestMapping(value={"/sys/tenant/user"}, produces={"application/json"})
@Api(value="\u79df\u6237\u7528\u6237\u7ed1\u5b9a", tags={"\u79df\u6237\u7ba1\u7406"})
public class SysTenantUserController {
    @Autowired
    private SysTenantMngService sysTenantService;
    @Autowired
    private ApiTenantService apiTenantService;

    @ApiOperation(value="\u7ed9\u7528\u6237\u7ed1\u5b9a\u79df\u6237")
    @ApiOperationSupport(order=21)
    @PutMapping(value={"/{userId}/bind/{tenantId}"})
    public ApiResult<Long> bindTenant(@PathVariable Long userId, @PathVariable Long tenantId) {
        return this.sysTenantService.updateUserBindTenant(userId, tenantId);
    }

    @ApiOperation(value="\u7ed9\u7528\u6237\u89e3\u7ed1\u79df\u6237")
    @ApiOperationSupport(order=22)
    @PutMapping(value={"/{userId}/unbind/{tenantId}"})
    public ApiResult<Long> unbindTenant(@PathVariable Long userId, @PathVariable Long tenantId) {
        return this.sysTenantService.updateUserUnbindTenant(userId, tenantId);
    }

    @ApiOperation(value="\u67e5\u8be2\u7528\u6237\u7ed1\u5b9a\u7684\u79df\u6237\u4fe1\u606f")
    @ApiOperationSupport(order=23)
    @GetMapping(value={"/tenants"})
    public ApiResult<List<SysUserTenantVO>> queryTenantOfUser(Long sysUserId) {
        return this.sysTenantService.queryTenantOfUser(sysUserId);
    }

    @ApiOperation(value="\u8bbe\u7f6e\u5f53\u524d\u767b\u5f55\u7684\u79df\u6237")
    @ApiOperationSupport(order=23)
    @GetMapping(value={"/setCurrentTenant/{tenantId}"})
    public ApiResult<Boolean> execSetCurrentTenant(@PathVariable Long tenantId) {
        return this.apiTenantService.execSetCurrentTenant(tenantId);
    }
}

