/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.tenant.controller;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.tenant.model.vo.SysTenantVO;
import com.elitescloud.cloudt.tenant.model.vo.params.SysTenantCreateParam;
import com.elitescloud.cloudt.tenant.model.vo.params.SysTenantQueryParam;
import com.elitescloud.cloudt.tenant.model.vo.params.SysTenantUpdateParam;
import com.elitescloud.cloudt.tenant.service.SysTenantMngService;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@ResponseBody
@RequestMapping(value={"/sys/sysTenant"})
@Api(value="\u79df\u6237\u7ba1\u7406", tags={"\u79df\u6237\u7ba1\u7406"})
public class SysTenantController {
    @Autowired
    private SysTenantMngService sysTenantService;

    @PostMapping(value={"/createOne"})
    @ApiOperation(value="\u521b\u5efa\u79df\u6237")
    @ApiOperationSupport(order=1)
    public ApiResult<Long> createOne(@Valid @RequestBody SysTenantCreateParam param) {
        return this.sysTenantService.add(param);
    }

    @PutMapping(value={"/update"})
    @ApiOperation(value="\u66f4\u65b0\u79df\u6237")
    @ApiOperationSupport(order=2)
    public ApiResult<Long> update(@Valid @RequestBody SysTenantUpdateParam param) {
        return this.sysTenantService.update(param);
    }

    @GetMapping(value={"/findIdOne/{id}"})
    @ApiOperation(value="\u901a\u8fc7ID\u67e5\u8be2\u79df\u6237\u8be6\u7ec6\u4fe1\u606f")
    @ApiOperationSupport(order=3)
    ApiResult<SysTenantVO> findIdOne(@PathVariable Long id) {
        return this.sysTenantService.getDetail(id);
    }

    @PostMapping(value={"/search"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u79df\u6237")
    @ApiOperationSupport(order=4)
    public ApiResult<PagingVO<SysTenantVO>> search(@RequestBody SysTenantQueryParam param) {
        return this.sysTenantService.search(param);
    }

    @ApiOperation(value="\u542f\u7528\u79df\u6237")
    @ApiOperationSupport(order=11)
    @PatchMapping(value={"/{id}/enabled"})
    public ApiResult<Long> enabled(@PathVariable Long id) {
        return this.sysTenantService.updateEnabled(id, true);
    }

    @ApiOperation(value="\u7981\u7528\u79df\u6237")
    @ApiOperationSupport(order=12)
    @PatchMapping(value={"/{id}/disabled"})
    public ApiResult<Long> disabled(@PathVariable Long id) {
        return this.sysTenantService.updateEnabled(id, false);
    }

    @DeleteMapping(value={"/deleteOne/{id}"})
    @ApiOperation(value="\u5220\u9664\u79df\u6237")
    @ApiImplicitParam(name="id", value="\u79df\u6237ID", paramType="path", required=true)
    public ApiResult<Long> deleteOne(@PathVariable(value="id") Long id) {
        return this.sysTenantService.deleteById(id);
    }

    @PutMapping(value={"/updateDeleteFlag/{id}"})
    @ApiOperation(value="\u903b\u8f91\u5220\u9664", hidden=true)
    @ApiImplicitParam(name="id", value="\u79df\u6237ID", paramType="path", required=true)
    public ApiResult<Object> updateDeleteFlag(@PathVariable(value="id") Long id) {
        this.sysTenantService.updateDeleteFlag(id);
        return ApiResult.ok();
    }
}

