/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.tenant.service.impl;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.core.annotation.TenantOrgTransaction;
import com.elitescloud.cloudt.core.annotation.TenantTransaction;
import com.elitescloud.cloudt.core.annotation.common.TenantIsolateType;
import com.elitescloud.cloudt.tenant.model.entity.SysTenantBaseDataSyncDO;
import com.elitescloud.cloudt.tenant.service.SysTenantBaseDataSyncService;
import com.elitescloud.cloudt.tenant.service.manager.SysTenantManager;
import com.elitescloud.cloudt.tenant.service.repo.SysTenantBaseDataSyncRepo;
import com.elitescloud.cloudt.tenant.service.repo.SysTenantBaseDataSyncRepoProc;
import com.elitescloud.cloudt.tenant.service.repo.SysTenantRepoProc;
import java.time.LocalDateTime;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.task.TaskExecutor;
import org.springframework.transaction.annotation.Transactional;

@TenantTransaction(isolateType=TenantIsolateType.DEFAULT)
@TenantOrgTransaction(useTenantOrg=false)
public class SysTenantBaseDataSyncServiceImpl
extends BaseServiceImpl
implements SysTenantBaseDataSyncService {
    private static final Logger log = LogManager.getLogger(SysTenantBaseDataSyncServiceImpl.class);
    @Autowired
    private SysTenantRepoProc tenantRepoProc;
    @Autowired
    private SysTenantBaseDataSyncRepo baseDataSyncRepo;
    @Autowired
    private SysTenantBaseDataSyncRepoProc baseDataSyncRepoProc;
    @Autowired
    private SysTenantManager tenantManager;
    @Autowired
    private TaskExecutor taskExecutor;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Boolean> execSyncData(Long tenantId) {
        boolean exists = this.tenantRepoProc.exists(tenantId);
        if (!exists) {
            return ApiResult.fail((String)"\u79df\u6237\u4e0d\u5b58\u5728");
        }
        exists = this.baseDataSyncRepoProc.existsUnFinished(tenantId, LocalDateTime.now().minusMinutes(30L));
        if (exists) {
            return ApiResult.fail((String)"\u8fd8\u6709\u8fdb\u884c\u4e2d\u7684\u540c\u6b65\u8bb0\u5f55\uff0c\u8bf7\u7a0d\u540e\u540e\u518d\u64cd\u4f5c");
        }
        this.addSync(tenantId);
        return ApiResult.ok((Object)true);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Boolean> execDealUnFinished() {
        this.baseDataSyncRepoProc.updateFinishedAll();
        return ApiResult.ok((Object)true);
    }

    private void addSync(Long tenantId) {
        SysTenantBaseDataSyncDO syncDO = new SysTenantBaseDataSyncDO();
        syncDO.setSysTenantId(tenantId);
        syncDO.setFinished(false);
        syncDO.setSuccess(false);
        syncDO.setStartTime(LocalDateTime.now());
        this.baseDataSyncRepo.save((Object)syncDO);
        this.tenantRepoProc.updateBaseDataSyncId(tenantId, syncDO.getId());
        CompletableFuture.runAsync(() -> this.tenantManager.syncBaseData(syncDO.getId(), tenantId), (Executor)this.taskExecutor).whenComplete((res, e) -> this.tenantManager.updateSyncResult(syncDO.getId(), (Throwable)e));
    }
}

