/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.tenant.service.impl;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.constant.TenantIsolateStrategy;
import com.elitescloud.cloudt.core.annotation.TenantOrgTransaction;
import com.elitescloud.cloudt.core.annotation.TenantTransaction;
import com.elitescloud.cloudt.core.annotation.common.TenantIsolateType;
import com.elitescloud.cloudt.system.service.model.entity.SysTenantDO;
import com.elitescloud.cloudt.tenant.config.TenantProperties;
import com.elitescloud.cloudt.tenant.convert.SysTenantDbMigrateConvert;
import com.elitescloud.cloudt.tenant.model.entity.SysTenantDbMigrateDO;
import com.elitescloud.cloudt.tenant.model.vo.SysTenantDbMigrateVO;
import com.elitescloud.cloudt.tenant.service.SysTenantDbMigrateService;
import com.elitescloud.cloudt.tenant.service.manager.SysTenantManager;
import com.elitescloud.cloudt.tenant.service.repo.SysTenantDbMigrateRepo;
import com.elitescloud.cloudt.tenant.service.repo.SysTenantDbMigrateRepoProc;
import com.elitescloud.cloudt.tenant.service.repo.SysTenantRepoProc;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@TenantTransaction(isolateType=TenantIsolateType.DEFAULT)
@TenantOrgTransaction(useTenantOrg=false)
public class SysTenantDbMigrateServiceImpl
implements SysTenantDbMigrateService {
    private static final Logger log = LogManager.getLogger(SysTenantDbMigrateServiceImpl.class);
    private static final SysTenantDbMigrateConvert CONVERT = SysTenantDbMigrateConvert.INSTANCE;
    @Autowired
    private TenantProperties tenantProperties;
    @Autowired
    private SysTenantDbMigrateRepo tenantDbMigrateRepo;
    @Autowired
    private SysTenantDbMigrateRepoProc tenantDbMigrateRepoProc;
    @Autowired
    private SysTenantRepoProc tenantRepoProc;
    @Autowired
    private SysTenantManager tenantManager;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> addInit(SysTenantDO tenantDO, TenantIsolateStrategy isolateStrategy, String appCode) {
        SysTenantDbMigrateDO migrateDO = this.tenantDbMigrateRepoProc.getByTenantAndAppCode(tenantDO.getId(), appCode);
        if (migrateDO != null) {
            return ApiResult.ok((Object)migrateDO.getId());
        }
        migrateDO = new SysTenantDbMigrateDO();
        migrateDO.setSysTenantId(tenantDO.getId());
        migrateDO.setAppCode(appCode);
        migrateDO.setTenantIsolation(isolateStrategy.name());
        migrateDO.setSchemaName(tenantDO.getSchemaName());
        migrateDO.setMigrateSuccess(false);
        migrateDO.setMigrateStartTime(LocalDateTime.now());
        this.tenantDbMigrateRepo.save((Object)migrateDO);
        return ApiResult.ok((Object)migrateDO.getId());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Set<String>> updateMigrateResultForTenant(Long tenantId, TenantIsolateStrategy isolateStrategy, Set<String> updatedApps) {
        if (this.tenantProperties.isDiscoveryClient() || this.tenantProperties.getClientNames().isEmpty()) {
            this.tenantRepoProc.updateDbInitialized(tenantId, true);
            return ApiResult.ok(Collections.emptySet());
        }
        LocalDateTime now = LocalDateTime.now();
        HashSet<String> failApps = new HashSet<String>();
        ArrayList<SysTenantDbMigrateDO> migrateDos = new ArrayList<SysTenantDbMigrateDO>();
        for (String clientName : this.tenantProperties.getClientNames()) {
            if (updatedApps.contains(clientName)) continue;
            SysTenantDbMigrateDO migrateDO = new SysTenantDbMigrateDO();
            migrateDO.setSysTenantId(tenantId);
            migrateDO.setAppCode(clientName);
            migrateDO.setTenantIsolation(isolateStrategy.name());
            migrateDO.setMigrateSuccess(false);
            migrateDO.setMigrateStartTime(now);
            migrateDO.setMigrateFinishTime(now);
            migrateDO.setFailReason("\u670d\u52a1\u4e0d\u5728\u7ebf");
            migrateDos.add(migrateDO);
            failApps.add(clientName);
        }
        if (migrateDos.isEmpty()) {
            this.tenantRepoProc.updateDbInitialized(tenantId, true);
        } else {
            this.tenantDbMigrateRepo.saveAll(migrateDos);
        }
        return ApiResult.ok(failApps);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> updateResult(Long id, boolean success, String failReason) {
        this.tenantDbMigrateRepoProc.updateResult(id, success, failReason);
        return ApiResult.ok((Object)id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> createTenantDb(Long tenantId) {
        SysTenantDO tenant = (SysTenantDO)this.tenantRepoProc.get(tenantId);
        if (tenant == null) {
            return ApiResult.fail((String)"\u79df\u6237\u4e0d\u5b58\u5728");
        }
        if (Boolean.TRUE.equals(tenant.getDbInitialized())) {
            return ApiResult.fail((String)"\u6570\u636e\u5e93\u5df2\u521d\u59cb\u5316");
        }
        this.tenantManager.syncClientDb(tenant);
        return ApiResult.ok((Object)tenantId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> retry(Long id) {
        SysTenantDbMigrateDO migrateDO = (SysTenantDbMigrateDO)((Object)this.tenantDbMigrateRepoProc.get(id));
        if (migrateDO == null) {
            return ApiResult.fail((String)"\u8bb0\u5f55\u4e0d\u5b58\u5728");
        }
        boolean retryResult = this.tenantManager.retryDbMigrate(migrateDO);
        if (retryResult) {
            this.updateTenantDbInitialized(migrateDO.getSysTenantId());
        }
        return retryResult ? ApiResult.ok((Object)id) : ApiResult.fail((String)"\u64cd\u4f5c\u5931\u8d25");
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> deleteTenantDb(Long tenantId) {
        SysTenantDO tenant = (SysTenantDO)this.tenantRepoProc.get(tenantId);
        if (tenant == null) {
            return ApiResult.fail((String)"\u79df\u6237\u4e0d\u5b58\u5728");
        }
        this.tenantManager.deleteClientDb(tenant);
        return ApiResult.ok((Object)tenantId);
    }

    @Override
    public ApiResult<List<SysTenantDbMigrateVO>> queryByTenant(Long tenantId) {
        List<SysTenantDbMigrateDO> migrateDos = this.tenantDbMigrateRepoProc.queryByTenantId(tenantId);
        if (migrateDos.isEmpty()) {
            return ApiResult.ok(Collections.emptyList());
        }
        List<SysTenantDbMigrateVO> vos = CONVERT.dos2Vos(migrateDos);
        return ApiResult.ok(vos);
    }

    private void updateTenantDbInitialized(Long tenantId) {
        long failNum = this.tenantDbMigrateRepoProc.countFailNum(tenantId);
        if (failNum == 0L) {
            this.tenantRepoProc.updateDbInitialized(tenantId, true);
        }
    }

    @Override
    public ApiResult<Long> getMigrateId(Long tenantId, String appCode) {
        SysTenantDbMigrateDO migrateDO = this.tenantDbMigrateRepoProc.getByTenantAndAppCode(tenantId, appCode);
        if (migrateDO != null) {
            return ApiResult.ok((Object)migrateDO.getId());
        }
        return ApiResult.ok(null);
    }
}

