package com.elitescloud.cloudt.tenant.service;

import com.elitescloud.boot.common.param.CodeNameParam;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.tenant.model.vo.params.SysTenantDatasourceRespVO;
import com.elitescloud.cloudt.tenant.model.vo.params.SysTenantDatasourceSaveVO;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2023/9/27
 */
public interface SysTenantDatasourceService {

    /**
     * 可分配数据源的应用列表
     *
     * @return 应用列表
     */
    ApiResult<List<CodeNameParam>> appList(Long sysTenantId);

    /**
     * 保存数据源
     *
     * @param saveVO 数据源信息
     * @return 数据源ID
     */
    ApiResult<Long> save(SysTenantDatasourceSaveVO saveVO);

    /**
     * 测试连接
     *
     * @param saveVO 数据源信息
     * @return 数据源ID
     */
    ApiResult<String> testConnection(SysTenantDatasourceSaveVO saveVO);

    /**
     * 获取数据源配置
     *
     * @param sysTenantId 租户ID
     * @param appCode     应用编码
     * @return 数据源配置
     */
    ApiResult<SysTenantDatasourceRespVO> get(@NotNull Long sysTenantId, @NotBlank String appCode);
}
