package com.elitescloud.cloudt.tenant.service;

import com.elitescloud.boot.common.param.IdCodeNameCheckParam;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.dto.SysTenantDTO;

import java.util.List;

/**
 * 租户查询服务接口.
 *
 * @author Kaiser（wang shao）
 * 2022/10/28
 */
public interface SysTenantQueryService {

    /**
     * 获取所有租户信息
     *
     * @return 租户信息
     */
    ApiResult<List<SysTenantDTO>> allTenants();

    /**
     * 根据ID获取租户信息
     *
     * @param id 租户ID
     * @return 租户信息
     */
    ApiResult<SysTenantDTO> getDtoById(Long id);

    /**
     * 查询用户的租户信息
     *
     * @param sysUserId 用户ID
     * @return
     */
    ApiResult<List<SysTenantDTO>> queryTenantDtoOfUser(Long sysUserId);

    /**
     * 获取租户绑定的应用
     *
     * @param tenantId 租户ID
     * @return
     */
    ApiResult<List<IdCodeNameCheckParam>> getApps(Long tenantId);
}
