/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.tenant.service.impl;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.RandomUtil;
import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.boot.constant.Gender;
import com.elitescloud.boot.constant.TenantConstant;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.tenant.client.TenantClientProperties;
import com.elitescloud.boot.wrapper.RedisWrapper;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.constant.TenantIsolateStrategy;
import com.elitescloud.cloudt.common.constant.Terminal;
import com.elitescloud.cloudt.core.annotation.TenantOrgTransaction;
import com.elitescloud.cloudt.core.annotation.TenantTransaction;
import com.elitescloud.cloudt.core.annotation.common.TenantIsolateType;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.constant.TenantType;
import com.elitescloud.cloudt.system.constant.UserSourceType;
import com.elitescloud.cloudt.system.constant.UserType;
import com.elitescloud.cloudt.system.dto.req.UserCreateDTO;
import com.elitescloud.cloudt.system.service.IUserService;
import com.elitescloud.cloudt.system.service.callback.TenantChangedCallback;
import com.elitescloud.cloudt.system.service.model.entity.SysTenantAppDO;
import com.elitescloud.cloudt.system.service.model.entity.SysTenantDO;
import com.elitescloud.cloudt.system.service.model.entity.SysTenantUserDO;
import com.elitescloud.cloudt.system.service.model.vo.SysUserTenantVO;
import com.elitescloud.cloudt.system.service.repo.SysTenantAppRepo;
import com.elitescloud.cloudt.system.service.repo.SysTenantAppRepoProc;
import com.elitescloud.cloudt.system.service.repo.SysTenantUserRepo;
import com.elitescloud.cloudt.system.service.repo.SysTenantUserRepoProc;
import com.elitescloud.cloudt.tenant.config.TenantProperties;
import com.elitescloud.cloudt.tenant.convert.SysTenantConvert;
import com.elitescloud.cloudt.tenant.model.vo.SysTenantVO;
import com.elitescloud.cloudt.tenant.model.vo.params.SysTenantCreateParam;
import com.elitescloud.cloudt.tenant.model.vo.params.SysTenantQueryParam;
import com.elitescloud.cloudt.tenant.model.vo.params.SysTenantUpdateParam;
import com.elitescloud.cloudt.tenant.service.SysTenantMngService;
import com.elitescloud.cloudt.tenant.service.manager.SysTenantManager;
import com.elitescloud.cloudt.tenant.service.repo.SysTenantRepo;
import com.elitescloud.cloudt.tenant.service.repo.SysTenantRepoProc;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@TenantTransaction(isolateType=TenantIsolateType.DEFAULT)
@TenantOrgTransaction(useTenantOrg=false)
public class SysTenantMngServiceImpl
extends BaseServiceImpl
implements SysTenantMngService {
    private static final Logger log = LogManager.getLogger(SysTenantMngServiceImpl.class);
    private static final SysTenantConvert CONVERT = SysTenantConvert.INSTANCE;
    @Autowired
    private SysTenantRepo sysTenantRepo;
    @Autowired
    private SysTenantRepoProc sysTenantRepoProc;
    @Autowired
    private SysTenantUserRepo sysTenantUserRepo;
    @Autowired
    private SysTenantUserRepoProc sysTenantUserRepoProc;
    @Autowired
    private SysTenantAppRepo tenantAppRepo;
    @Autowired
    private SysTenantAppRepoProc tenantAppRepoProc;
    @Autowired
    private TenantProperties tenantProperties;
    @Autowired
    private TenantClientProperties tenantClientProperties;
    @Autowired
    private SysTenantManager tenantManager;
    @Autowired
    private IUserService userService;
    @Autowired
    private RedisWrapper redisWrapper;
    @Autowired
    private ObjectProvider<TenantChangedCallback> tenantChangedCallbacks;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> add(SysTenantCreateParam createParam) {
        boolean dbInitialized;
        try {
            this.checkForSave(createParam);
        }
        catch (IllegalArgumentException e) {
            return ApiResult.fail((String)("\u521b\u5efa\u79df\u6237\u5931\u8d25\uff0c" + e.getMessage()));
        }
        long adminUserId = this.createTenantAdmin(createParam);
        SysTenantDO tenantDO = CONVERT.saveParam2Do(createParam);
        tenantDO.setSysUserId(Long.valueOf(adminUserId));
        tenantDO.setTenantType(TenantType.COMMON.getValue());
        boolean bl = dbInitialized = Boolean.TRUE.equals(this.tenantProperties.isAutoSyncDb()) && (CharSequenceUtil.equals((CharSequence)tenantDO.getTenantIsolation(), (CharSequence)TenantIsolateStrategy.SCHEMA.name()) || CharSequenceUtil.equals((CharSequence)tenantDO.getTenantIsolation(), (CharSequence)TenantIsolateStrategy.DATABASE.name()));
        if (TenantIsolateStrategy.FIELD.name().equals(tenantDO.getTenantIsolation())) {
            dbInitialized = true;
        }
        tenantDO.setDbInitialized(Boolean.valueOf(dbInitialized));
        tenantDO.setCreateTime(LocalDateTime.now());
        this.sysTenantRepo.save(tenantDO);
        if (Boolean.TRUE.equals(this.tenantProperties.isAutoSyncDb())) {
            this.tenantManager.syncClientDb(tenantDO);
        }
        this.bindTenantUser(adminUserId, tenantDO.getId());
        this.clearCache();
        for (TenantChangedCallback callback : this.tenantChangedCallbacks) {
            callback.onSave(true, tenantDO.getId().longValue());
        }
        return ApiResult.ok((Object)tenantDO.getId());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> update(SysTenantUpdateParam updateParam) {
        SysTenantDO tenantDO = this.sysTenantRepo.findById(updateParam.getId()).orElse(null);
        try {
            this.checkForUpdate(updateParam, tenantDO);
        }
        catch (IllegalArgumentException e) {
            return ApiResult.fail((String)("\u4fee\u6539\u79df\u6237\u5931\u8d25\uff0c" + e.getMessage()));
        }
        Long adminId = this.updateTenantAdmin(updateParam, tenantDO.getSysUserId());
        tenantDO.setSysUserId(adminId);
        CONVERT.convertUpdateParam(updateParam, tenantDO);
        tenantDO.setModifyTime(LocalDateTime.now());
        this.sysTenantRepo.save(tenantDO);
        this.bindTenantUser(adminId, tenantDO.getId());
        this.clearCache();
        for (TenantChangedCallback callback : this.tenantChangedCallbacks) {
            callback.onSave(false, tenantDO.getId().longValue());
        }
        return ApiResult.ok((Object)tenantDO.getId());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> updateEnabled(Long id, Boolean enabled) {
        GeneralUserDetails user = SecurityContextUtil.currentUserIfUnauthorizedThrow();
        if (!user.isOperation()) {
            return ApiResult.fail((String)"\u65e0\u6743\u9650\u64cd\u4f5c");
        }
        this.sysTenantRepoProc.updateEnabled(id, Boolean.TRUE.equals(enabled));
        this.clearCache();
        for (TenantChangedCallback callback : this.tenantChangedCallbacks) {
            callback.onEnabled(id.longValue(), Boolean.TRUE.equals(enabled));
        }
        return ApiResult.ok((Object)id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> deleteById(Long id) {
        GeneralUserDetails user = SecurityContextUtil.currentUserIfUnauthorizedThrow();
        if (!user.isOperation()) {
            return ApiResult.fail((String)"\u65e0\u6743\u9650\u64cd\u4f5c");
        }
        Boolean dbInitialized = this.sysTenantRepoProc.isDbInitialized(id);
        if (dbInitialized != null && dbInitialized.booleanValue()) {
            return ApiResult.fail((String)"\u8bf7\u5148\u6e05\u7406\u8868\u7ed3\u6784");
        }
        this.sysTenantRepoProc.delete(id);
        this.clearCache();
        for (TenantChangedCallback callback : this.tenantChangedCallbacks) {
            callback.onDelete(id.longValue(), true);
        }
        return ApiResult.ok((Object)id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> updateDeleteFlag(Long id) {
        GeneralUserDetails user = SecurityContextUtil.currentUserIfUnauthorizedThrow();
        if (!user.isOperation()) {
            return ApiResult.fail((String)"\u65e0\u6743\u9650\u64cd\u4f5c");
        }
        this.sysTenantRepoProc.updateDeleteFlag(id);
        this.clearCache();
        for (TenantChangedCallback callback : this.tenantChangedCallbacks) {
            callback.onDelete(id.longValue(), false);
        }
        return ApiResult.ok((Object)id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> updateUserBindTenant(Long userId, Long tenantId) {
        this.bindTenantUser(userId, tenantId);
        return ApiResult.ok((Object)userId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> updateUserUnbindTenant(Long userId, Long tenantId) {
        this.sysTenantUserRepoProc.unbindTenant(tenantId.longValue(), userId.longValue());
        return ApiResult.ok((Object)userId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> saveApps(Long tenantId, Set<String> appCode) {
        if (tenantId == null) {
            return ApiResult.fail((String)"\u79df\u6237ID\u4e3a\u7a7a");
        }
        Set existsCodes = this.tenantAppRepoProc.getAppCode(tenantId);
        LocalDateTime now = LocalDateTime.now();
        ArrayList<SysTenantAppDO> codesToAdd = new ArrayList<SysTenantAppDO>(appCode.size());
        SysTenantAppDO appDO = null;
        for (String s : appCode) {
            if (existsCodes.contains(s)) continue;
            appDO = new SysTenantAppDO();
            appDO.setAppCode(s);
            appDO.setSysTenantId(tenantId);
            appDO.setAssignTime(now);
            codesToAdd.add(appDO);
        }
        HashSet<String> codesToDel = new HashSet<String>(existsCodes.size());
        for (String s : existsCodes) {
            if (appCode.contains(s)) continue;
            codesToDel.add(s);
        }
        if (!codesToAdd.isEmpty()) {
            this.tenantAppRepo.saveAll(codesToAdd);
        }
        if (!codesToDel.isEmpty()) {
            this.tenantAppRepoProc.deleteByTenantAndAppCode(tenantId, codesToDel);
        }
        this.clearCache();
        return ApiResult.ok((Object)tenantId);
    }

    @Override
    public ApiResult<SysTenantVO> getDetail(Long id) {
        SysTenantDO tenantDO = (SysTenantDO)this.sysTenantRepoProc.get(id);
        if (tenantDO == null) {
            return ApiResult.fail((String)"\u6570\u636e\u4e0d\u5b58\u5728");
        }
        SysTenantVO tenantVO = CONVERT.doToVO(tenantDO);
        tenantVO.setAdminUserId(tenantDO.getSysUserId());
        if (StringUtils.hasText((String)tenantVO.getIndustry())) {
            tenantVO.setIndustryName(this.getUdcIndustry().get(tenantVO.getIndustry()));
        }
        if (StringUtils.hasText((String)tenantVO.getCustomer())) {
            tenantVO.setCustomerName(this.getUdcCustomer().get(tenantVO.getCustomer()));
        }
        return ApiResult.ok((Object)tenantVO);
    }

    @Override
    public ApiResult<Boolean> exists(Long id) {
        Assert.notNull((Object)id, (String)"\u79df\u6237ID\u4e3a\u7a7a");
        boolean exists = this.sysTenantRepoProc.exists(id);
        return ApiResult.ok((Object)exists);
    }

    @Override
    public ApiResult<PagingVO<SysTenantVO>> search(SysTenantQueryParam param) {
        PagingVO<SysTenantVO> queryResult = this.sysTenantRepoProc.query(param);
        if (!CollectionUtils.isEmpty((Collection)queryResult.getRecords())) {
            Map<String, String> industryMap = null;
            Map<String, String> customerMap = null;
            for (SysTenantVO tenantVO : queryResult.getRecords()) {
                if (CharSequenceUtil.isNotBlank((CharSequence)tenantVO.getIndustry())) {
                    if (industryMap == null) {
                        industryMap = this.getUdcIndustry();
                    }
                    tenantVO.setIndustryName(industryMap.get(tenantVO.getIndustry()));
                }
                if (!CharSequenceUtil.isNotBlank((CharSequence)tenantVO.getCustomer())) continue;
                if (customerMap != null) {
                    customerMap = this.getUdcIndustry();
                }
                tenantVO.setCustomerName(customerMap.get(tenantVO.getCustomer()));
            }
        }
        return ApiResult.ok(queryResult);
    }

    @Override
    public ApiResult<List<SysUserTenantVO>> queryTenantOfUser(Long sysUserId) {
        List tenants = this.sysTenantUserRepoProc.queryUserTenant(sysUserId);
        return ApiResult.ok((Object)tenants);
    }

    private void bindTenantUser(Long userId, Long tenantId) {
        List existsTenantIds = this.sysTenantUserRepoProc.getTenantIdOfUser(userId);
        if (existsTenantIds.contains(tenantId)) {
            return;
        }
        SysTenantUserDO tenantUserDO = new SysTenantUserDO();
        tenantUserDO.setSysUserId(userId);
        tenantUserDO.setSysTenantId(tenantId);
        tenantUserDO.setBindTime(LocalDateTime.now());
        tenantUserDO.setEnabled(Boolean.valueOf(true));
        this.sysTenantUserRepo.save((Object)tenantUserDO);
    }

    private Long updateTenantAdmin(SysTenantUpdateParam updateParam, Long adminId) {
        if (!StringUtils.hasText((String)updateParam.getAdminAccount())) {
            return adminId;
        }
        Long newAdminId = this.userService.getUniqueIdByUsername(updateParam.getAdminAccount());
        if (newAdminId != null) {
            if (newAdminId.longValue() == adminId.longValue()) {
                return adminId;
            }
            this.addTenantAdminAttribute(newAdminId);
            this.removeTenantAdminAttribute(adminId);
            return newAdminId;
        }
        newAdminId = this.addNewAdminUser(updateParam.getAdminAccount(), updateParam.getTenantName(), updateParam.getContactNumber());
        this.removeTenantAdminAttribute(adminId);
        return newAdminId;
    }

    private Long createTenantAdmin(SysTenantCreateParam createParam) {
        Long adminId = this.userService.getUniqueIdByUsername(createParam.getAdminAccount());
        if (adminId != null) {
            this.addTenantAdminAttribute(adminId);
            return adminId;
        }
        return this.addNewAdminUser(createParam.getAdminAccount(), createParam.getTenantName(), createParam.getContactNumber());
    }

    private Long addNewAdminUser(String username, String tenantName, String mobile) {
        UserCreateDTO createDTO = new UserCreateDTO();
        createDTO.setUsername(username);
        createDTO.setFullName(tenantName + "\u7ba1\u7406\u5458");
        createDTO.setGender(Gender.SECRET.getValue());
        createDTO.setMobile(mobile);
        createDTO.setEnabled(Boolean.valueOf(true));
        createDTO.setSourceType(UserSourceType.SYS.getValue());
        createDTO.setTerminalsAdd(Set.of(Terminal.BACKEND.name()));
        createDTO.setTypesAdd(Set.of(UserType.ADMIN_TENANT.getValue()));
        Long userId = null;
        try {
            userId = this.userService.insertUser(createDTO);
        }
        catch (Exception e) {
            throw new BusinessException("\u521b\u5efa\u7ba1\u7406\u5458\u8d26\u53f7\u5931\u8d25\uff1a" + e.getMessage(), (Throwable)e);
        }
        this.sysTenantUserRepoProc.unbindTenant(TenantConstant.DEFAULT_TENANT_ID.longValue(), userId.longValue());
        return userId;
    }

    private void addTenantAdminAttribute(Long adminId) {
        this.userService.addUserTerminal(adminId, Set.of(Terminal.BACKEND.name()));
        this.userService.addUserType(adminId, Set.of(UserType.ADMIN_TENANT.getValue()));
    }

    private void removeTenantAdminAttribute(Long adminId) {
        this.userService.removeUserType(adminId, Set.of(UserType.ADMIN_TENANT.getValue()));
    }

    private void checkForSave(SysTenantCreateParam createParam) {
        TenantIsolateStrategy isolation;
        GeneralUserDetails currentUser = SecurityContextUtil.currentUserIfUnauthorizedThrow();
        Assert.isTrue((boolean)currentUser.isOperation(), (String)"\u65e0\u6743\u9650\u64cd\u4f5c");
        boolean exists = this.sysTenantRepoProc.existsTenantCode(createParam.getTenantCode(), null);
        Assert.isTrue((!exists ? 1 : 0) != 0, (String)"\u7f16\u7801\u5df2\u5b58\u5728");
        createParam.setEnabled((Boolean)ObjectUtil.defaultIfNull((Object)createParam.getEnabled(), (Object)false));
        exists = this.userService.existsUsername(createParam.getAdminAccount(), null);
        Assert.isTrue((!exists ? 1 : 0) != 0, (String)"\u7ba1\u7406\u5458\u8d26\u53f7\u5df2\u5b58\u5728");
        if (StringUtils.hasText((String)createParam.getContactNumber())) {
            exists = this.userService.existsMobile(createParam.getContactNumber(), null);
            Assert.isTrue((!exists ? 1 : 0) != 0, (String)"\u624b\u673a\u53f7\u5df2\u5b58\u5728");
        }
        if ((isolation = this.tenantClientProperties.getIsolateStrategy()) != null) {
            createParam.setTenantIsolation(isolation.name());
        }
        if (TenantIsolateStrategy.SCHEMA == isolation) {
            Assert.hasText((String)createParam.getSchemaName(), (String)"schema\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        } else if (TenantIsolateStrategy.FIELD != isolation) {
            throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u6570\u636e\u9694\u79bb\u7b56\u7565");
        }
        if (isolation == TenantIsolateStrategy.SCHEMA) {
            String schemaName = createParam.getSchemaName().toLowerCase();
            exists = this.sysTenantRepoProc.existsSchemaName(schemaName, null);
            Assert.isTrue((!exists ? 1 : 0) != 0, (String)"schema\u540d\u79f0\u5df2\u5b58\u5728");
            Assert.isTrue((boolean)this.validateSchemaName(schemaName), (String)"schema\u540d\u79f0\u53ea\u80fd\u662f\u5c0f\u5199\u5b57\u6bcd\u548c\u4e0b\u5212\u7ebf\u7ec4\u6210");
            createParam.setSchemaName(schemaName);
        }
        if (CharSequenceUtil.isBlank((CharSequence)createParam.getTenantDomain())) {
            createParam.setTenantDomain(this.generateRandomDomain());
        } else {
            Assert.isTrue((boolean)this.validateChildDomain(createParam.getTenantDomain()), (String)"\u57df\u540d\u683c\u5f0f\u4e0d\u6b63\u786e");
            exists = this.sysTenantRepoProc.existsTenantDomain(createParam.getTenantDomain(), null);
            Assert.isTrue((!exists ? 1 : 0) != 0, (String)"\u57df\u540d\u5df2\u5b58\u5728");
        }
        if (CharSequenceUtil.isNotBlank((CharSequence)createParam.getCustomDomain())) {
            String customDomain = this.normalizeDomain(createParam.getCustomDomain());
            Assert.isTrue((boolean)this.validateDomain(customDomain), (String)"\u57df\u540d\u683c\u5f0f\u4e0d\u6b63\u786e");
            exists = this.sysTenantRepoProc.existsCustomDomain(createParam.getCustomDomain(), null);
            Assert.isTrue((!exists ? 1 : 0) != 0, (String)"\u81ea\u5b9a\u4e49\u57df\u540d\u5df2\u5b58\u5728");
            createParam.setCustomDomain(customDomain);
        }
    }

    private void checkForUpdate(SysTenantUpdateParam updateParam, SysTenantDO tenantDOOld) {
        TenantIsolateStrategy strategy;
        TenantIsolateStrategy isolation;
        GeneralUserDetails currentUser = SecurityContextUtil.currentUserIfUnauthorizedThrow();
        Assert.isTrue((boolean)currentUser.isOperation(), (String)"\u65e0\u6743\u9650\u64cd\u4f5c");
        Assert.notNull((Object)tenantDOOld, (String)"\u4fee\u6539\u7684\u6570\u636e\u4e0d\u5b58\u5728");
        Long id = updateParam.getId();
        boolean exists = this.sysTenantRepoProc.existsTenantCode(updateParam.getTenantCode(), id);
        Assert.isTrue((!exists ? 1 : 0) != 0, (String)"\u7f16\u7801\u5df2\u5b58\u5728");
        updateParam.setEnabled((Boolean)ObjectUtil.defaultIfNull((Object)updateParam.getEnabled(), (Object)false));
        if (StringUtils.hasText((String)updateParam.getContactNumber()) && !updateParam.getContactNumber().equals(tenantDOOld.getContactNumber())) {
            exists = this.userService.existsMobile(updateParam.getContactNumber(), tenantDOOld.getSysUserId());
            Assert.isTrue((!exists ? 1 : 0) != 0, (String)"\u624b\u673a\u53f7\u5df2\u5b58\u5728");
        }
        if ((isolation = this.tenantClientProperties.getIsolateStrategy()) != null) {
            updateParam.setTenantIsolation(isolation.name());
        }
        if (TenantIsolateStrategy.SCHEMA == isolation) {
            Assert.hasText((String)updateParam.getSchemaName(), (String)"schema\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        } else if (TenantIsolateStrategy.FIELD != isolation) {
            throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u6570\u636e\u9694\u79bb\u7b56\u7565");
        }
        if (Boolean.TRUE.equals(tenantDOOld.getDbInitialized()) && (strategy = SysTenantMngServiceImpl.convertTenantIsolate(updateParam.getTenantIsolation())) != TenantIsolateStrategy.DATABASE && strategy == TenantIsolateStrategy.SCHEMA) {
            Assert.isTrue((boolean)CharSequenceUtil.equals((CharSequence)updateParam.getSchemaName(), (CharSequence)tenantDOOld.getSchemaName()), (String)"\u6570\u636e\u5e93\u5df2\u521d\u59cb\u5316\uff0c\u4e0d\u53ef\u4fee\u6539schema");
        }
        if (CharSequenceUtil.isNotBlank((CharSequence)updateParam.getTenantDomain()) && !CharSequenceUtil.equals((CharSequence)updateParam.getTenantDomain(), (CharSequence)tenantDOOld.getTenantDomain())) {
            Assert.isTrue((boolean)this.validateChildDomain(updateParam.getTenantDomain()), (String)"\u57df\u540d\u683c\u5f0f\u4e0d\u6b63\u786e");
            exists = this.sysTenantRepoProc.existsTenantDomain(updateParam.getTenantDomain(), id);
            Assert.isTrue((!exists ? 1 : 0) != 0, (String)"\u57df\u540d\u5df2\u5b58\u5728");
        }
        if (CharSequenceUtil.isNotBlank((CharSequence)updateParam.getCustomDomain()) && !CharSequenceUtil.equals((CharSequence)updateParam.getCustomDomain(), (CharSequence)tenantDOOld.getCustomDomain())) {
            String customDomain = this.normalizeDomain(updateParam.getCustomDomain());
            Assert.isTrue((boolean)this.validateDomain(customDomain), (String)"\u57df\u540d\u683c\u5f0f\u4e0d\u6b63\u786e");
            exists = this.sysTenantRepoProc.existsCustomDomain(updateParam.getCustomDomain(), id);
            Assert.isTrue((!exists ? 1 : 0) != 0, (String)"\u81ea\u5b9a\u4e49\u57df\u540d\u5df2\u5b58\u5728");
        }
    }

    private void clearCache() {
        try {
            this.redisWrapper.apply(() -> {
                String cacheKey = "cloudt_tenant:all";
                this.redisUtils.del(new String[]{cacheKey});
                return null;
            }, null);
        }
        catch (Exception e) {
            log.error("\u6e05\u7406redis\u4e2d\u79df\u6237\u7f13\u5b58\u5f02\u5e38\uff1a", (Throwable)e);
        }
    }

    private boolean validateSchemaName(String schemaName) {
        String pattern = "[a-z|0-9|_]+";
        Pattern r = Pattern.compile(pattern);
        Matcher m = r.matcher(schemaName);
        return m.matches();
    }

    private boolean validateChildDomain(String childDomain) {
        String pattern = "[a-z|0-9|-]+";
        Pattern r = Pattern.compile(pattern);
        Matcher m = r.matcher(childDomain);
        return m.matches();
    }

    private boolean validateDomain(String domain) {
        String pattern = "[a-zA-Z0-9][-a-zA-Z0-9]{0,62}(\\.[a-zA-Z0-9][-a-zA-Z0-9]{0,62})+\\.?";
        Pattern r = Pattern.compile(pattern);
        Matcher matcher = r.matcher(domain);
        return matcher.matches();
    }

    private String normalizeDomain(String domain) {
        if ((domain = domain.toLowerCase()).startsWith("http://")) {
            domain = domain.substring(7);
        } else if (domain.startsWith("https://")) {
            domain = domain.substring(8);
        }
        domain = domain.endsWith("/") ? domain.substring(0, domain.length() - 1) : domain;
        return domain;
    }

    private String generateRandomDomain() {
        String domain;
        while (this.sysTenantRepoProc.existsTenantDomain(domain = RandomUtil.randomString((int)9), null)) {
        }
        return domain;
    }

    static TenantIsolateStrategy convertTenantIsolate(String isolate) {
        if (!StringUtils.hasText((String)isolate)) {
            return null;
        }
        return TenantIsolateStrategy.parse((String)isolate);
    }

    private Map<String, String> getUdcIndustry() {
        return super.udcMap("cloudt-system", "INDUSTRY");
    }

    private Map<String, String> getUdcCustomer() {
        return super.udcMap("cloudt-system", "CUSTOMER");
    }
}

