package com.elitescloud.cloudt.tenant.controller;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.tenant.model.vo.SysTenantDbMigrateVO;
import com.elitescloud.cloudt.tenant.service.SysTenantDbMigrateService;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 租户数据库创建.
 *
 * @author Kaiser（wang shao）
 * 2022/3/28
 */
@ResponseBody
@RequestMapping(value = "/sys/sysTenant/dbMigrate", produces = MediaType.APPLICATION_JSON_VALUE)
@Api(value = "租户数据库", tags = {"租户数据库"})
public class SysTenantDbMigrateController {

    @Autowired
    private SysTenantDbMigrateService tenantDbMigrateService;

    /**
     * 获取租户的数据库创建记录
     *
     * @param tenantId 租户ID
     * @return 创建记录
     */
    @ApiOperation(value = "获取租户的数据库创建记录")
    @ApiOperationSupport(order = 1)
    @ApiImplicitParam(name = "tenantId", value = "租户ID")
    @GetMapping(value = "/{tenantId}/record")
    public ApiResult<List<SysTenantDbMigrateVO>> queryByTenantId(@PathVariable Long tenantId) {
        return tenantDbMigrateService.queryByTenant(tenantId);
    }

    /**
     * 创建租户数据库
     *
     * @param tenantId 租户ID
     * @return 租户ID
     */
    @ApiOperation(value = "创建租户数据库")
    @ApiOperationSupport(order = 2)
    @ApiImplicitParam(name = "tenantId", value = "租户ID")
    @PostMapping(value = "/{tenantId}/start")
    public ApiResult<Long> createTenantDb(@PathVariable Long tenantId) {
        return tenantDbMigrateService.createTenantDb(tenantId);
    }

    /**
     * 重新执行指定的数据库创建
     *
     * @param id 记录ID
     * @return 创建记录ID
     */
    @ApiOperation(value = "重新执行指定的数据库创建")
    @ApiOperationSupport(order = 3)
    @ApiImplicitParam(name = "id", value = "创建记录ID")
    @PostMapping(value = "/{id}/retry")
    public ApiResult<Long> retry(@PathVariable Long id) {
        return tenantDbMigrateService.retry(id);
    }

    /**
     * 删除租户数据库
     *
     * @param tenantId 租户ID
     * @return 租户ID
     */
    @ApiOperation(value = "删除租户数据库")
    @ApiOperationSupport(order = 4)
    @ApiImplicitParam(name = "tenantId", value = "租户ID")
    @DeleteMapping(value = "/{tenantId}/delete")
    public ApiResult<Long> deleteTenantDb(@PathVariable Long tenantId) {
        return tenantDbMigrateService.deleteTenantDb(tenantId);
    }
}
