package com.elitescloud.cloudt.tenant.provider.callback;

import com.elitescloud.cloudt.system.service.callback.AppChangedCallback;
import com.elitescloud.cloudt.system.service.repo.SysTenantAppRepoProc;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 租户应用删除回调.
 *
 * @author Kaiser（wang shao）
 * @date 2023/4/24
 */
@Component
public class TenantAppDeletedCallback implements AppChangedCallback {
    @Autowired
    private SysTenantAppRepoProc tenantAppRepoProc;

    @Override
    public void onDelete(String appCode, boolean real) {
        tenantAppRepoProc.deleteByApp(appCode);
    }
}
