package com.elitescloud.cloudt.tenant.service.repo;

import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.tenant.model.entity.QSysTenantDatasourceDO;
import com.elitescloud.cloudt.tenant.model.entity.SysTenantDatasourceDO;
import org.springframework.stereotype.Repository;

import javax.validation.constraints.NotBlank;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2023/9/26
 */
@Repository
public class SysTenantDatasourceRepoProc extends BaseRepoProc<SysTenantDatasourceDO> {
    private static final QSysTenantDatasourceDO QDO = QSysTenantDatasourceDO.sysTenantDatasourceDO;

    public SysTenantDatasourceRepoProc() {
        super(QDO);
    }

    /**
     * 获取租户的数据源配置
     *
     * @param sysTenantId
     * @param appCode
     * @return
     */
    public SysTenantDatasourceDO getByTenantAndApp(long sysTenantId, @NotBlank String appCode) {
        var predicate = QDO.sysTenantId.eq(sysTenantId).and(QDO.appCode.eq(appCode));

        return super.jpaQueryFactory.selectFrom(QDO)
                .where(predicate)
                .limit(1)
                .fetchOne();
    }
}
