/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.tenant.service.impl;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjUtil;
import com.elitescloud.boot.provider.IdFactory;
import com.elitescloud.boot.tenant.client.common.TenantClient;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.tenant.convert.TestDemoConvert;
import com.elitescloud.cloudt.tenant.model.entity.TestDemoDO;
import com.elitescloud.cloudt.tenant.model.vo.TestDemoVO;
import com.elitescloud.cloudt.tenant.model.vo.params.TestDemoSaveVO;
import com.elitescloud.cloudt.tenant.service.TestDemoService;
import com.elitescloud.cloudt.tenant.service.repo.TestDemoRepo;
import com.elitescloud.cloudt.tenant.service.repo.TestDemoRepoProc;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;
import javax.persistence.EntityManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TestDemoServiceImpl
implements TestDemoService {
    private static final TestDemoConvert CONVERT = TestDemoConvert.INSTANCE;
    @Autowired
    private TestDemoRepo testDemoRepo;
    @Autowired
    private TestDemoRepoProc testDemoRepoProc;
    @Autowired
    private EntityManager entityManager;
    @Autowired
    private JPAQueryFactory jpaQueryFactory;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> save(TestDemoSaveVO saveVO) {
        TestDemoDO demoDO;
        if (CharSequenceUtil.isBlank((CharSequence)saveVO.getUsername())) {
            return ApiResult.fail((String)"\u7528\u6237\u540d\u4e3a\u7a7a");
        }
        boolean exits = this.testDemoRepoProc.existsUsername(saveVO.getUsername(), saveVO.getId());
        if (exits) {
            return ApiResult.fail((String)"\u7528\u6237\u540d\u5df2\u5b58\u5728");
        }
        TestDemoDO testDemoDO = demoDO = saveVO.getId() == null ? null : (TestDemoDO)((Object)this.testDemoRepoProc.get(saveVO.getId()));
        if (demoDO == null) {
            demoDO = new TestDemoDO();
        }
        CONVERT.saveVo2Do(saveVO, demoDO);
        demoDO.setJoinTime(LocalDateTime.now());
        demoDO.setAge((Integer)ObjUtil.defaultIfNull((Object)saveVO.getAge(), (Object)0));
        if (demoDO.getAge() == 0) {
            TestDemoDO newDO = (TestDemoDO)((Object)this.testDemoRepo.save((Object)demoDO));
            System.out.println(newDO.getId());
        } else if (demoDO.getAge() == 1) {
            TestDemoDO newDO = (TestDemoDO)((Object)this.entityManager.merge((Object)demoDO));
            System.out.println(newDO.getId());
        } else if (demoDO.getAge() == 2) {
            if (demoDO.getId() == null) {
                demoDO.setId(IdFactory.generateLong());
            }
            TestDemoDO newDO = (TestDemoDO)((Object)this.entityManager.merge((Object)demoDO));
            System.out.println(newDO.getId());
        } else if (demoDO.getAge() == 3) {
            this.testDemoRepoProc.save((Serializable)((Object)demoDO));
            System.out.println(demoDO.getId());
        } else {
            if (demoDO.getId() == null) {
                this.entityManager.persist((Object)demoDO);
            } else {
                TestDemoDO newDO = (TestDemoDO)((Object)this.entityManager.merge((Object)demoDO));
                System.out.println(newDO.getId());
            }
            System.out.println(demoDO.getId());
        }
        return ApiResult.ok((Object)demoDO.getId());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> upsert(String username, Long id) {
        id = this.testDemoRepoProc.upsert(username, id);
        return ApiResult.ok((Object)id);
    }

    @Override
    public ApiResult<List<TestDemoVO>> queryAll() {
        List dos = this.testDemoRepo.findAll();
        List<TestDemoVO> result = CONVERT.do2Vo(dos);
        return ApiResult.ok(result);
    }

    @Override
    @Async
    public void test() {
        System.out.println(TenantClient.getCurrentTenant());
    }
}

