package com.elitescloud.cloudt.tenant.model.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.time.LocalDateTime;

/**
 * 租户测试表.
 *
 * @author Kaiser（wang shao）
 * 2022/3/25
 */
@Entity
@Table(name = "test_demo_classes")
@Comment("测试课程表")
@Getter
@Setter
@Accessors(chain = true)
@DynamicUpdate
@DynamicInsert
public class TestDemoClassesDO extends BaseModel {
    private static final long serialVersionUID = 3986767067197239226L;

    @Comment("用户名")
    @Column()
    private String username;

    @Comment("课程")
    @Column()
    private String classes;
}
