package com.elitescloud.cloudt.tenant.model.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * 2022/3/28
 */
@ApiModel(description = "数据库更新记录")
@Data
public class SysTenantDbMigrateVO implements Serializable {
    private static final long serialVersionUID = -2860862323547792741L;

    /**
     * 记录ID
     */
    @ApiModelProperty(value = "记录ID", position = 1)
    private Long id;

    /**
     * 应用编码
     */
    @ApiModelProperty(value = "应用编码", position = 2)
    private String appCode;

    /**
     * 创建开始时间
     */
    @ApiModelProperty(value = "创建开始时间", position = 3)
    private LocalDateTime migrateStartTime;

    /**
     * 是否创建成功
     */
    @ApiModelProperty(value = "是否创建成功", position = 4)
    private Boolean migrateSuccess;

    /**
     * 创建结束时间
     */
    @ApiModelProperty(value = "创建结束时间", position = 5)
    private LocalDateTime migrateFinishTime;

    /**
     * 创建失败原因
     */
    @ApiModelProperty(value = "失败原因", position = 6)
    private String failReason;
}
