package com.elitescloud.cloudt.tenant.service.impl;

import cn.hutool.core.map.MapUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjUtil;
import com.elitescloud.boot.provider.IdFactory;
import com.elitescloud.boot.provider.TenantClientProvider;
import com.elitescloud.boot.tenant.client.common.TenantClient;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.context.util.HttpServletUtil;
import com.elitescloud.cloudt.system.service.model.entity.QSysBusinessOperationParamDO;
import com.elitescloud.cloudt.tenant.convert.TestDemoConvert;
import com.elitescloud.cloudt.tenant.model.entity.TestDemoDO;
import com.elitescloud.cloudt.tenant.model.vo.TestDemoVO;
import com.elitescloud.cloudt.tenant.model.vo.params.TestDemoSaveVO;
import com.elitescloud.cloudt.tenant.service.TestDemoService;
import com.elitescloud.cloudt.tenant.service.repo.TestDemoRepo;
import com.elitescloud.cloudt.tenant.service.repo.TestDemoRepoProc;
import com.querydsl.jpa.impl.JPAQueryFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

import javax.persistence.EntityManager;
import javax.servlet.http.HttpServletRequest;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * 2022/3/25
 */
@Service
public class TestDemoServiceImpl implements TestDemoService {

    private static final TestDemoConvert CONVERT = TestDemoConvert.INSTANCE;

    @Autowired
    private TestDemoRepo testDemoRepo;
    @Autowired
    private TestDemoRepoProc testDemoRepoProc;
    @Autowired
    private EntityManager entityManager;
    @Autowired
    private JPAQueryFactory jpaQueryFactory;

    @Transactional(rollbackFor = Exception.class)
    @Override
    public ApiResult<Long> save(TestDemoSaveVO saveVO) {
        if (CharSequenceUtil.isBlank(saveVO.getUsername())) {
            return ApiResult.fail("用户名为空");
        }

        boolean exits = testDemoRepoProc.existsUsername(saveVO.getUsername(), saveVO.getId());
        if (exits) {
            return ApiResult.fail("用户名已存在");
        }

        TestDemoDO demoDO = saveVO.getId() == null ? null : testDemoRepoProc.get(saveVO.getId());
        if (demoDO == null) {
            demoDO = new TestDemoDO();
        }
        CONVERT.saveVo2Do(saveVO, demoDO);
        demoDO.setJoinTime(LocalDateTime.now());
        demoDO.setAge(ObjUtil.defaultIfNull(saveVO.getAge(), 0));

        if (demoDO.getAge() == 0) {
            var newDO = testDemoRepo.save(demoDO);
            System.out.println(newDO.getId());
        } else if (demoDO.getAge() == 1) {
            var newDO = entityManager.merge(demoDO);
            System.out.println(newDO.getId());
        } else if (demoDO.getAge() == 2) {
            if (demoDO.getId() == null) {
                demoDO.setId(IdFactory.generateLong());
            }
            var newDO = entityManager.merge(demoDO);
            System.out.println(newDO.getId());
        } else if (demoDO.getAge() == 3) {
            testDemoRepoProc.save(demoDO);
            System.out.println(demoDO.getId());
        } else {
            if (demoDO.getId() == null) {
                entityManager.persist(demoDO);
            } else {
                var newDO = entityManager.merge(demoDO);
                System.out.println(newDO.getId());
            }
            System.out.println(demoDO.getId());
        }
//        testDemoRepoProc.save(demoDO);

        return ApiResult.ok(demoDO.getId());
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public ApiResult<Long> upsert(String username, Long id) {
        id = testDemoRepoProc.upsert(username, id);
        return ApiResult.ok(id);
    }

    @Override
    public ApiResult<List<TestDemoVO>> queryAll() {
        var dos = testDemoRepo.findAll();

        var result = CONVERT.do2Vo(dos);
        return ApiResult.ok(result);
    }

    @Async
    @Override
    public void test() {
        System.out.println(TenantClient.getCurrentTenant());
    }
}
