package com.elitescloud.coord.messenger.sender.provider.param;

import lombok.Builder;
import lombok.Data;
import org.springframework.util.Assert;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import java.io.Serializable;
import java.util.Objects;
import java.util.Set;

/**
 * 基本邮件信息.
 *
 * @author Kaiser（wang shao）
 * @date 3/22/2023
 */
@Data
public abstract class BaseEmailDTO implements Serializable {
    private static final long serialVersionUID = -7180197514581404751L;

    /**
     * 业务类型
     */
    @NotBlank(message = "业务类型不能为空")
    private String businessType;

    /**
     * 配置编码
     */
    @NotBlank(message = "配置编码不能为空")
    private String cfgCode;

    /**
     * 邮件主题
     */
    @NotBlank(message = "主题不能为空")
    private String subject;

    /**
     * 收件人
     */
    @NotEmpty(message = "收件人不能为空")
    private Set<Address> to;

    /**
     * 回复人
     */
    private Address replyTo;

    /**
     * 抄送人
     */
    private Set<Address> cc;

    /**
     * 秘送人
     */
    private Set<Address> bcc;

    /**
     * 是否是富文本
     */
    private Boolean rich;

    @Data
    @Builder
    public static class Address implements Serializable {
        private static final long serialVersionUID = -913485802185212548L;
        @NotBlank(message = "邮箱地址不能为空")
        private String emailAddress;
        /**
         * 联系人名称
         */
        private String personName;

        public Address(String emailAddress, String personName) {
            this.emailAddress = emailAddress;
            this.personName = personName;
            Assert.hasText(emailAddress, "邮件地址不能为空");
        }

        public Address(String emailAddress) {
            this.emailAddress = emailAddress;
            Assert.hasText(emailAddress, "邮件地址不能为空");
        }

        public Address() {
        }

        @Override
        public int hashCode() {
            return Objects.hashCode(getEmailAddress());
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof Address) {
                Address the = (Address) obj;
                if (getEmailAddress() == null) {
                    return the.getEmailAddress() == null;
                }
                return getEmailAddress().equals(the.getEmailAddress());
            }
            return false;
        }
    }
}
