package com.elitescloud.coord.messenger.sender.provider.param;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.util.Map;

/**
 * 模板短信.
 *
 * @author Kaiser（wang shao）
 * @date 3/22/2023
 */
@Data
public class TemplateSmsDTO extends BaseSmsDTO {
    private static final long serialVersionUID = -8458201036632084840L;

    /**
     * 模板编码
     */
    @NotBlank(message = "模板编号不能为空")
    private String templateCode;

    /**
     * 短信签名
     */
    private String signName;

    /**
     * 模板参数
     */
    private Map<String, String> templateParams;
}
