package com.elitescloud.coord.messenger.site.provider;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.coord.messenger.site.provider.param.MsgSiteSimpleMessenger;
import com.elitescloud.coord.messenger.Application;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import javax.validation.Valid;

/**
 * @author Chris
 * @date 2021-08-26
 */
@FeignClient(name = Application.NAME, path = MsgSiteMessengerDubboService.URI)
@Validated
public interface MsgSiteMessengerDubboService {
    String URI = Application.URI_PREFIX + "/msg_site";

    /**
     * 简易发送站内信接口，只支持指定账号/公司发送
     *
     * @param messenger 消息体
     * @return result
     */
    @PostMapping(value = "/simpleSend")
    ApiResult<Object> simpleSend(@RequestBody @Valid MsgSiteSimpleMessenger messenger);
}
