package com.elitescloud.coord.messenger.site.provider.param;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.util.List;

/**
 * @author Chris
 * @date 2021-08-26
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class MsgSiteSimpleMessenger implements Serializable {

    private static final long serialVersionUID = -4838443737028004813L;

    @ApiModelProperty(value = "标题")
    @NotBlank(message = "标题不能为空")
    private String title;

    @ApiModelProperty("消息类型")
    @NotBlank(message = "消息类型不能为空")
    private String msgType;

    @ApiModelProperty("消息级别")
    @NotBlank(message = "消息级别不能为空")
    private String msgLevel;

    @ApiModelProperty(value = "文本内容")
    @NotBlank(message = "消息类型不能为空")
    private String content;

    @ApiModelProperty(value = "指定接收用户名")
    private List<String> usernames;

    @ApiModelProperty(value = "指定接收公司编号")
    private List<String> ouCodes;

    @ApiModelProperty(value = "指定接收角色编号，只有公司编号填写了才有效")
    private List<String> roleCodes;
}
