package com.elitescloud.cloudt.messenger.model;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

/**
 * 消息父类.
 *
 * @author Kaiser（wang shao）
 * @date 2023/5/22
 */
@Data
public abstract class AbstractMessageVO implements Serializable {
    private static final long serialVersionUID = -3140898858787668662L;

    /**
     * 消息渠道
     */
    @ApiModelProperty(value = "消息渠道，未指定时使用默认的", position = 1)
    private String channelCode;

    /**
     * 是否同步发送，默认false
     */
    @ApiModelProperty(value = "是否同步发送，默认false", position = 2)
    private Boolean sync;

    /**
     * 计划发送时间
     */
    @ApiModelProperty(value = "计划发送时间", position = 3)
    private LocalDateTime plannedTime;

    /**
     * 发送配置
     */
    @ApiModelProperty(value = "发送配置", position = 4)
    private Map<String, Object> properties;

    /**
     * 操作人
     */
    @ApiModelProperty(value = "操作人", position = 5)
    private String creator;

    /**
     * 消息主题
     */
    @NotBlank(message = "消息主题不能为空")
    @ApiModelProperty(value = "消息主题", position = 11, required = true)
    private String subject;

    /**
     * 消息内容
     */
    @NotBlank(message = "消息内容不能为空")
    @ApiModelProperty(value = "消息内容", position = 12, required = true)
    private String content;

    /**
     * 发送人
     */
    @Valid
    @ApiModelProperty(value = "发送人", position = 13)
    private MessageAccountVO sender;

    /**
     * 接收人
     */
    @NotEmpty(message = "接收人不能为空")
    @Valid
    @ApiModelProperty(value = "接收人", position = 14, required = true)
    private List<MessageAccountVO> receiverList;
}
